/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PlayerSessionCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nc").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"session").then(class_2170.method_9247((String)"clear").executes(PlayerSessionCommand::clearSession))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"chapter_index", (ArgumentType)IntegerArgumentType.integer()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getChapterSuggestions()).then(class_2170.method_9244((String)"scene_name", (ArgumentType)StringArgumentType.string()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getSceneSuggestionsByChapter()).executes(context -> PlayerSessionCommand.setSession((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"chapter_index"), StringArgumentType.getString((CommandContext)context, (String)"scene_name"))))))));
    }

    private static int setSession(CommandContext<class_2168> context, int chapterIndex, String sceneName) {
        if (!NarrativeCraftMod.getInstance().getChapterManager().chapterExists(chapterIndex)) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("chapter.no_exists", chapterIndex));
            return 0;
        }
        Chapter chapter = NarrativeCraftMod.getInstance().getChapterManager().getChapterByIndex(chapterIndex);
        if (!chapter.sceneExists(sceneName)) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("scene.no_exists", sceneName, chapterIndex));
            return 0;
        }
        Scene scene = chapter.getSceneByName(sceneName);
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        playerSession.setChapter(chapter);
        playerSession.setScene(scene);
        ((class_2168)context.getSource()).method_9226(() -> Translation.message("session.set", chapter.getIndex(), scene.getName()), false);
        return 1;
    }

    private static int clearSession(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)player);
        playerSession.reset();
        ((class_2168)context.getSource()).method_9226(() -> Translation.message("session.cleared", new Object[0]), false);
        return 1;
    }
}

