/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.util.Position2D;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_9848;

public class DialogParametersInkAction
extends InkAction {
    private static final Set<String> VALID_PARAMETERS = Set.of("offset", "scale", "padding", "width", "text_color", "background_color", "gap", "letter_spacing", "no_skip", "manual_skip", "auto_skip", "bobbing");
    private ParameterType parameterType;
    private float value1;
    private float value2;

    public DialogParametersInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() < 2) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Parameter available: " + String.join((CharSequence)", ", VALID_PARAMETERS)));
        }
        String parameter = arguments.get(1).toLowerCase();
        this.parameterType = ParameterType.fromString(parameter);
        if (this.parameterType == null) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Valid parameters: " + String.join((CharSequence)", ", VALID_PARAMETERS)));
        }
        int expectedArgs = 2 + this.parameterType.getExpectedValues();
        if (arguments.size() < expectedArgs) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Expected " + this.parameterType.getExpectedValues() + " value(s) for " + parameter));
        }
        return this.parseValues(arguments);
    }

    private InkActionResult parseValues(List<String> arguments) {
        try {
            switch (this.parameterType.ordinal()) {
                case 0: 
                case 2: 
                case 11: {
                    this.value1 = Float.parseFloat(arguments.get(2));
                    this.value2 = Float.parseFloat(arguments.get(3));
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 10: {
                    this.value1 = Float.parseFloat(arguments.get(2));
                    break;
                }
                case 3: {
                    this.value1 = Integer.parseInt(arguments.get(2));
                }
                case 4: 
                case 5: {
                    this.value1 = Integer.parseInt(arguments.get(2), 16);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(2)));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        DialogRenderer dialogRenderer = playerSession.getDialogRenderer();
        StoryHandler storyHandler = playerSession.getStoryHandler();
        this.executeParameter(dialogRenderer, storyHandler);
        if (dialogRenderer != null) {
            dialogRenderer.update();
        }
        this.isRunning = false;
        return InkActionResult.ok();
    }

    private void executeParameter(DialogRenderer dialogRenderer, StoryHandler storyHandler) {
        switch (this.parameterType.ordinal()) {
            case 0: {
                this.executeIfRenderer3D(dialogRenderer, renderer3D -> renderer3D.setDialogOffset(new Position2D(this.value1, this.value2)));
                this.executeDialogData(storyHandler, dialogData -> dialogData.setOffset(new Position2D(this.value1, this.value2)));
                break;
            }
            case 1: {
                this.executeIfRenderer(dialogRenderer, renderer -> renderer.setScale(this.value1));
                this.executeDialogData(storyHandler, dialogData -> dialogData.setScale(this.value1));
                break;
            }
            case 2: {
                this.executeIfRenderer(dialogRenderer, renderer -> {
                    renderer.setPaddingX(this.value1);
                    renderer.setPaddingY(this.value2);
                });
                this.executeDialogData(storyHandler, dialogData -> {
                    dialogData.setPaddingX(this.value1);
                    dialogData.setPaddingY(this.value2);
                });
                break;
            }
            case 3: {
                this.executeIfRenderer(dialogRenderer, renderer -> renderer.setWidth(this.value1));
                this.executeDialogData(storyHandler, dialogData -> dialogData.setWidth(this.value1));
                break;
            }
            case 4: {
                this.executeIfRenderer(dialogRenderer, renderer -> {
                    int color = class_9848.method_61330((int)255, (int)((int)this.value1));
                    renderer.setTextColor(color);
                });
                this.executeDialogData(storyHandler, dialogData -> {
                    int color = class_9848.method_61330((int)255, (int)((int)this.value1));
                    dialogData.setTextColor(color);
                });
                break;
            }
            case 5: {
                this.executeIfRenderer(dialogRenderer, renderer -> {
                    int color = class_9848.method_61330((int)255, (int)((int)this.value1));
                    renderer.setBackgroundColor(color);
                });
                this.executeDialogData(storyHandler, dialogData -> {
                    int color = class_9848.method_61330((int)255, (int)((int)this.value1));
                    dialogData.setBackgroundColor(color);
                });
                break;
            }
            case 6: {
                this.executeIfRenderer(dialogRenderer, renderer -> renderer.setGap(this.value1));
                this.executeDialogData(storyHandler, dialogData -> dialogData.setGap(this.value1));
                break;
            }
            case 7: {
                this.executeIfRenderer(dialogRenderer, renderer -> renderer.setLetterSpacing(this.value1));
                this.executeDialogData(storyHandler, dialogData -> dialogData.setLetterSpacing(this.value1));
                break;
            }
            case 8: {
                this.executeDialogData(storyHandler, dialogData -> dialogData.setNoSkip(true));
                break;
            }
            case 9: {
                this.executeIfRenderer(dialogRenderer, renderer -> renderer.setNoSkip(false));
                this.executeDialogData(storyHandler, dialogData -> dialogData.setNoSkip(false));
                break;
            }
            case 10: {
                this.executeIfRenderer(dialogRenderer, renderer -> {
                    if (this.value1 > 0.0f) {
                        renderer.stopAutoSkip();
                    } else {
                        renderer.autoSkipAt(this.value1);
                    }
                });
                this.executeDialogData(storyHandler, dialogData -> {
                    if (this.value1 > 0.0f) {
                        dialogData.setDialogAutoSkip(true);
                        dialogData.setAutoSkipSeconds(this.value1);
                    } else {
                        dialogData.setDialogAutoSkip(false);
                        dialogData.setAutoSkipSeconds(0.0);
                    }
                });
                break;
            }
            case 11: {
                this.executeIfRenderer3D(dialogRenderer, renderer -> renderer.updateBobbing(this.value1, this.value2));
                this.executeDialogData(storyHandler, dialogData -> {
                    dialogData.setNoiseShakeSpeed(this.value1);
                    dialogData.setNoiseShakeStrength(this.value2);
                });
            }
        }
    }

    private void executeIfRenderer(DialogRenderer renderer, Consumer<DialogRenderer> action) {
        if (renderer != null) {
            action.accept(renderer);
        }
    }

    private void executeIfRenderer3D(DialogRenderer renderer, Consumer<DialogRenderer3D> action) {
        if (renderer instanceof DialogRenderer3D) {
            DialogRenderer3D renderer3D = (DialogRenderer3D)renderer;
            action.accept(renderer3D);
        }
    }

    private void executeDialogData(StoryHandler storyHandler, Consumer<DialogData> action) {
        if (storyHandler == null) {
            return;
        }
        DialogData dialogData = storyHandler.getDialogData();
        action.accept(dialogData);
    }

    @Override
    public boolean needScene() {
        return false;
    }

    private static enum ParameterType {
        OFFSET(2),
        SCALE(1),
        PADDING(2),
        WIDTH(1),
        TEXT_COLOR(1),
        BACKGROUND_COLOR(1),
        GAP(1),
        LETTER_SPACING(1),
        NO_SKIP(0),
        MANUAL_SKIP(0),
        AUTO_SKIP(1),
        BOBBING(2);

        private final int expectedValues;

        private ParameterType(int expectedValues) {
            this.expectedValues = expectedValues;
        }

        public int getExpectedValues() {
            return this.expectedValues;
        }

        public static ParameterType fromString(String parameter) {
            try {
                return ParameterType.valueOf(parameter.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

