/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.keyframe;

import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.controllers.keyframe.KeyframeControllerInterface;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_5498;

public abstract class AbstractKeyframeController<T extends Keyframe>
extends AbstractController
implements KeyframeControllerInterface<T> {
    protected final List<KeyframeTrigger> keyframeTriggers = new ArrayList<KeyframeTrigger>();
    protected final List<CharacterStoryData> characterStoryDataList = new ArrayList<CharacterStoryData>();
    protected final AtomicInteger keyframesCounter = new AtomicInteger();
    protected class_1934 lastGameType;

    public AbstractKeyframeController(Environment environment, class_1657 player) {
        super(environment, player);
    }

    protected KeyframeLocation getKeyframeLocationFromPlayer() {
        class_3222 player = this.playerSession.getPlayer();
        return new KeyframeLocation(player.method_73189().method_1031(0.0, (double)player.method_5751(), 0.0), player.method_36455(), player.method_36454(), 0.0f, 85.0f);
    }

    @Override
    public void setCamera(Keyframe keyframe) {
        class_310 minecraft = class_310.method_1551();
        minecraft.field_1690.method_31043(class_5498.field_26664);
        if (this.playerSession.getCurrentCamera() != null && keyframe == null) {
            this.playerSession.setCurrentCamera(null);
            this.playerSession.getPlayer().method_7336(this.lastGameType);
            minecraft.field_1690.field_1842 = false;
            this.showKeyframes(this.playerSession.getPlayer());
            class_243 pos = this.playerSession.getPlayer().method_73189();
            this.playerSession.getPlayer().method_5859(pos.field_1352, pos.field_1351 - 5.0 - (double)this.playerSession.getPlayer().method_5751(), pos.field_1350);
            return;
        }
        if (keyframe == null) {
            return;
        }
        if (this.playerSession.getCurrentCamera() == null) {
            this.lastGameType = this.playerSession.getPlayer().method_68876();
        }
        this.playerSession.getPlayer().method_7336(class_1934.field_9219);
        this.playerSession.setCurrentCamera(keyframe.getKeyframeLocation());
        this.hideKeyframes(this.playerSession.getPlayer());
        minecraft.field_1690.field_1842 = true;
        if (this.environment == Environment.DEVELOPMENT) {
            minecraft.execute(() -> minecraft.method_1507(this.keyframeOptionScreen(keyframe, false)));
        }
    }

    @Override
    public KeyframeTrigger getKeyframeTriggerByEntity(class_1297 entity) {
        for (KeyframeTrigger keyframeTrigger : this.keyframeTriggers) {
            if (!Util.isSameEntity(entity, (class_1297)keyframeTrigger.getCamera())) continue;
            return keyframeTrigger;
        }
        return null;
    }

    @Override
    public void addKeyframeTrigger(int tick, String commands) {
        KeyframeTrigger keyframeTrigger = new KeyframeTrigger(this.keyframesCounter.incrementAndGet(), tick, commands, this.getKeyframeLocationFromPlayer());
        keyframeTrigger.showKeyframe(this.playerSession.getPlayer());
        this.keyframeTriggers.add(keyframeTrigger);
    }

    @Override
    public void removeKeyframeTrigger(KeyframeTrigger keyframeTrigger) {
        this.keyframeTriggers.remove(keyframeTrigger);
        keyframeTrigger.hideKeyframe(this.playerSession.getPlayer());
    }

    public abstract class_437 keyframeOptionScreen(Keyframe var1, boolean var2);

    public List<KeyframeTrigger> getKeyframeTriggers() {
        return this.keyframeTriggers;
    }

    public CharacterRuntime getCharacterFromEntity(class_1297 entity) {
        for (CharacterRuntime characterRuntime : this.playerSession.getCharacterRuntimes()) {
            if (!Util.isSameEntity(entity, (class_1297)characterRuntime.getEntity())) continue;
            return characterRuntime;
        }
        return null;
    }

    public CharacterStoryData getCharacterStoryDataFromEntity(class_1297 entity) {
        for (CharacterStoryData characterStoryData : this.characterStoryDataList) {
            if (!Util.isSameEntity(entity, (class_1297)characterStoryData.getCharacterRuntime().getEntity())) continue;
            return characterStoryData;
        }
        return null;
    }

    public List<CharacterStoryData> getCharacterStoryDataList() {
        return this.characterStoryDataList;
    }
}

