/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import com.mojang.datafixers.util.Pair;
import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionType;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2744;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

public class ItemChangeAction
extends Action {
    private final int itemId;
    private final int oldItemId;
    private final String data;
    private final String oldData;
    private final String equipmentSlot;

    public ItemChangeAction(int waitTick, String equipmentSlot, class_1799 itemStack, class_1799 oldItemStack, class_5455 registryAccess) {
        super(waitTick, ActionType.ITEM_CHANGE);
        this.itemId = class_7923.field_41178.method_10206((Object)itemStack.method_7909());
        this.oldItemId = class_7923.field_41178.method_10206((Object)oldItemStack.method_7909());
        this.equipmentSlot = equipmentSlot;
        this.data = this.getItemComponents(itemStack, registryAccess);
        this.oldData = this.getItemComponents(oldItemStack, registryAccess);
    }

    private String getItemComponents(class_1799 itemStack, class_5455 registryAccess) {
        if (itemStack.method_7960()) {
            return null;
        }
        class_2520 tag = Util.getItemTag(itemStack, registryAccess);
        class_2520 componentsTag = ((class_2487)tag).method_10580("components");
        if (componentsTag != null) {
            return componentsTag.toString();
        }
        return null;
    }

    @Override
    public void execute(PlaybackData playbackData) {
        class_1297 class_12972 = playbackData.getEntity();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            this.changeItem(livingEntity, this.itemId, this.data);
        }
    }

    @Override
    public void rewind(PlaybackData playbackData) {
        class_1297 class_12972 = playbackData.getEntity();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            this.changeItem(livingEntity, this.oldItemId, this.oldData);
        }
    }

    private void changeItem(class_1309 entity, int itemId, String data) {
        class_2487 tag;
        class_1792 item = (class_1792)class_7923.field_41178.method_10200(itemId);
        class_1799 itemStack = new class_1799((class_1935)item);
        if (data != null && (tag = Util.tagFromIdAndComponents(item, data)) != null) {
            itemStack = Util.generateItemStackFromNBT(tag, entity.method_56673());
        }
        entity.method_73183().method_8503().method_3760().method_14581((class_2596)new class_2744(entity.method_5628(), List.of(new Pair((Object)class_1304.valueOf((String)this.equipmentSlot), (Object)itemStack))));
        entity.method_5673(class_1304.valueOf((String)this.equipmentSlot), itemStack);
    }
}

