/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.screens.controller.cutscene.CutsceneSettingsScreen;
import fr.loudo.narrativecraft.screens.keyframe.KeyframeTriggerScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public class CutsceneControllerScreen
extends class_437 {
    private final class_2561 pauseText = class_2561.method_43470((String)"\u23f8");
    private final class_2561 playText = class_2561.method_43470((String)"\u25b6");
    private final int BUTTON_HEIGHT = 20;
    private int initialY;
    private int totalWidthControllerBtn;
    private class_4185 controllerButton;
    private final CutsceneController cutsceneController;

    public CutsceneControllerScreen(CutsceneController cutsceneController) {
        super((class_2561)class_2561.method_43470((String)"Cutscene Controller Screen"));
        this.cutsceneController = cutsceneController;
    }

    protected void method_25426() {
        this.initialY = this.field_22790 - 80;
        this.initControllerButtons();
        this.initKeyframesButton();
        this.initSettingsButton();
    }

    private void initControllerButtons() {
        int pauseBtnWidth = 20;
        int btnWidth = 50;
        int gap = 5;
        this.totalWidthControllerBtn = pauseBtnWidth + btnWidth * 2 + gap * 2;
        int startX = (this.field_22789 - this.totalWidthControllerBtn) / 2;
        String previousText = "- %.1fs";
        class_4185 previousSkip = class_4185.method_46430((class_2561)class_2561.method_43470((String)String.format(previousText, (double)this.cutsceneController.getSkipTickCount() / 20.0)), button -> this.cutsceneController.previousSecondSkip()).method_46434(startX, this.initialY, btnWidth, 20).method_46431();
        this.controllerButton = class_4185.method_46430((class_2561)(this.cutsceneController.isPlaying() ? this.pauseText : this.playText), button -> this.playOrPause()).method_46434(startX + btnWidth + gap, this.initialY, pauseBtnWidth, 20).method_46431();
        String nextText = "+ %.1fs";
        class_4185 nextSkip = class_4185.method_46430((class_2561)class_2561.method_43470((String)String.format(nextText, (double)this.cutsceneController.getSkipTickCount() / 20.0)), button -> this.cutsceneController.nextSecondSkip()).method_46434(startX + btnWidth + gap + pauseBtnWidth + gap, this.initialY, btnWidth, 20).method_46431();
        this.method_37063((class_364)previousSkip);
        this.method_37063((class_364)this.controllerButton);
        this.method_37063((class_364)nextSkip);
    }

    private void initKeyframesButton() {
        int btnWidth = 30;
        int gap = 5;
        int totalWidth = btnWidth * 3 + gap * 2 + 15;
        int controllerStartX = (this.field_22789 - this.totalWidthControllerBtn) / 2;
        int startX = controllerStartX - gap - totalWidth;
        class_4185 createKeyframeGroup = class_4185.method_46430((class_2561)ImageFontConstants.CREATE_KEYFRAME_GROUP, button -> {
            CutsceneKeyframeGroup keyframeGroup = this.cutsceneController.createKeyframeGroup();
            if (keyframeGroup == null) {
                return;
            }
            this.field_22787.field_1724.method_7353((class_2561)Translation.message("controller.cutscene.keyframe_group_created", keyframeGroup.getId()), false);
        }).method_46434(startX, this.initialY, btnWidth, 20).method_46431();
        createKeyframeGroup.method_47400(class_7919.method_47407((class_2561)Translation.message("tooltip.create_keyframe_group", new Object[0])));
        class_4185 addKeyframe = class_4185.method_46430((class_2561)ImageFontConstants.ADD_KEYFRAME, button -> this.cutsceneController.createKeyframe()).method_46434(startX + btnWidth + gap, this.initialY, btnWidth, 20).method_46431();
        addKeyframe.method_47400(class_7919.method_47407((class_2561)Translation.message("tooltip.create_keyframe", new Object[0])));
        class_4185 addTriggerKeyframe = class_4185.method_46430((class_2561)ImageFontConstants.ADD_KEYFRAME_TRIGGER, button -> {
            KeyframeTriggerScreen screen = new KeyframeTriggerScreen((AbstractKeyframeController<? extends Keyframe>)this.cutsceneController, this.cutsceneController.getCurrentTick());
            this.field_22787.method_1507((class_437)screen);
        }).method_46434(startX + (btnWidth + gap) * 2, this.initialY, btnWidth, 20).method_46431();
        addTriggerKeyframe.method_47400(class_7919.method_47407((class_2561)Translation.message("tooltip.create_keyframe_trigger", new Object[0])));
        this.method_37063((class_364)createKeyframeGroup);
        this.method_37063((class_364)addKeyframe);
        this.method_37063((class_364)addTriggerKeyframe);
    }

    private void initSettingsButton() {
        int btnWidth = 30;
        int controllerStartX = (this.field_22789 - this.totalWidthControllerBtn) / 2;
        int startX = controllerStartX + this.totalWidthControllerBtn + 15;
        class_4185 settingsButton = class_4185.method_46430((class_2561)ImageFontConstants.SETTINGS, button -> this.field_22787.method_1507((class_437)new CutsceneSettingsScreen(this.cutsceneController, this, (class_2561)Translation.message("controller.cutscene.settings.screen_name", new Object[0])))).method_46434(startX, this.initialY, btnWidth, 20).method_46431();
        settingsButton.method_47400(class_7919.method_47407((class_2561)Translation.message("tooltip.cutscene_settings", new Object[0])));
        this.method_37063((class_364)settingsButton);
        startX = settingsButton.method_46426() + settingsButton.method_25368() + 5;
        class_4185 saveButton = class_4185.method_46430((class_2561)ImageFontConstants.SAVE, button -> {
            NarrativeCraftMod.server.execute(() -> this.cutsceneController.stopSession(true));
            this.method_25419();
        }).method_46434(startX, this.initialY, btnWidth, 20).method_46431();
        saveButton.method_47400(class_7919.method_47407((class_2561)Translation.message("tooltip.save", new Object[0])));
        this.method_37063((class_364)saveButton);
        startX = saveButton.method_46426() + saveButton.method_25368() + 5;
        class_4185 closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2716"), button -> {
            class_410 confirm = new class_410(b -> {
                if (b) {
                    NarrativeCraftMod.server.execute(() -> this.cutsceneController.stopSession(false));
                    this.method_25419();
                } else {
                    this.field_22787.method_1507((class_437)this);
                }
            }, (class_2561)class_2561.method_43470((String)""), (class_2561)Translation.message("controller.confirm_leaving", new Object[0]), class_5244.field_24336, class_5244.field_24335);
            this.field_22787.method_1507((class_437)confirm);
        }).method_46434(startX, this.initialY, btnWidth, 20).method_46431();
        closeButton.method_47400(class_7919.method_47407((class_2561)Translation.message("tooltip.leave_without_saving", new Object[0])));
        this.method_37063((class_364)closeButton);
    }

    private void playOrPause() {
        if (this.cutsceneController.isPlaying()) {
            this.cutsceneController.pause();
            this.controllerButton.method_25355(this.playText);
        } else {
            if (this.cutsceneController.atMaxTick()) {
                return;
            }
            this.cutsceneController.resume();
            this.controllerButton.method_25355(this.pauseText);
        }
    }

    protected void method_57734(class_332 guiGraphics) {
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean method_25421() {
        return false;
    }

    public class_4185 getControllerButton() {
        return this.controllerButton;
    }

    public class_2561 getPauseText() {
        return this.pauseText;
    }

    public class_2561 getPlayText() {
        return this.playText;
    }
}

