/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.animations;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.screens.components.ChooseCharacterScreen;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.animations.EditScreenAnimationAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8021;

public class AnimationsScreen
extends StoryElementScreen {
    private final Scene scene;

    public AnimationsScreen(Scene scene) {
        super((class_2561)Translation.message("screen.story_manager.animation_list", scene.getName()));
        this.scene = scene;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24339, p_345997_ -> this.method_25419()).method_46432(200).method_46431());
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)new ScenesMenuScreen(this.scene));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.scene.getAnimations().stream().map(animation -> {
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)animation.getName()), button1 -> {}).method_46431();
            button.field_22763 = false;
            return new StoryElementList.StoryEntryData(button, List.of(this.createSettingsButton((Animation)animation)), () -> this.field_22787.method_1507(new EditInfoScreen<Animation>(this, (Animation)animation, new EditScreenAnimationAdapter(this.scene))), () -> {
                this.field_22787.method_1507((class_437)new AnimationsScreen(this.scene));
                this.scene.removeAnimation((Animation)animation);
                NarrativeCraftFile.deleteAnimationFile(animation);
                this.field_22787.method_1507((class_437)new AnimationsScreen(this.scene));
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.method_48999((class_8021)new StoryElementList(this.field_22787, this, entries, true));
    }

    private class_4185 createSettingsButton(Animation animation) {
        return class_4185.method_46430((class_2561)ImageFontConstants.SETTINGS, button1 -> {
            ChooseCharacterScreen screen = new ChooseCharacterScreen((class_437)this, Translation.message("screen.story_manager.link_animation_character", new Object[0]).getString(), animation.getCharacter(), this.scene, characterStory -> {
                if (characterStory == null) {
                    ScreenUtils.sendToast((class_2561)Translation.message("global.error", new Object[0]), (class_2561)Translation.message("character.must_link_character", new Object[0]));
                    return;
                }
                CharacterStory oldCharacter = animation.getCharacter();
                try {
                    animation.setCharacter((CharacterStory)characterStory);
                    NarrativeCraftFile.updateAnimationFile(animation);
                }
                catch (IOException e) {
                    Util.sendCrashMessage((class_1657)this.field_22787.field_1724, e);
                    animation.setCharacter(oldCharacter);
                }
            });
            this.field_22787.method_1507((class_437)screen);
        }).method_46431();
    }

    @Override
    protected void openFolder() {
        class_156.method_668().method_60932(NarrativeCraftFile.getAnimationsFolder(this.scene).toPath());
    }
}

