/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.PickElementScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.cutscene.EditScreenCutsceneAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class CutscenesScreen
extends StoryElementScreen {
    private final Scene scene;
    private boolean shiftPressed;
    private class_4185 settingsButton;

    public CutscenesScreen(Scene scene) {
        super((class_2561)Translation.message("screen.story_manager.cutscene_list", scene.getName()));
        this.scene = scene;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<Cutscene> screen = new EditInfoScreen<Cutscene>(this, null, new EditScreenCutsceneAdapter(this.scene));
            this.field_22787.method_1507(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24339, p_345997_ -> this.method_25419()).method_46432(200).method_46431());
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)new ScenesMenuScreen(this.scene));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.scene.getCutscenes().stream().map(cutscene -> {
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)cutscene.getName()), button1 -> {
                NarrativeCraftMod.server.execute(() -> new CutsceneController(Environment.DEVELOPMENT, (class_1657)this.field_22787.field_1724, (Cutscene)cutscene).startSession());
                this.field_22787.method_1507(null);
            }).method_46431();
            this.settingsButton = this.createSettingsButton((Cutscene)cutscene);
            this.settingsButton.method_47400(class_7919.method_47407((class_2561)(this.shiftPressed ? Translation.message("screen.story_manager.animation_cutscene_link", new Object[0]) : Translation.message("screen.story_manager.subscene_cutscene_link", new Object[0]))));
            return new StoryElementList.StoryEntryData(button, List.of(this.settingsButton), () -> this.field_22787.method_1507(new EditInfoScreen<Cutscene>(this, (Cutscene)cutscene, new EditScreenCutsceneAdapter(this.scene))), () -> {
                this.field_22787.method_1507((class_437)new CutscenesScreen(this.scene));
                try {
                    this.scene.removeCutscene((Cutscene)cutscene);
                    NarrativeCraftFile.updateCutsceneFile(this.scene);
                    this.field_22787.method_1507((class_437)new CutscenesScreen(this.scene));
                }
                catch (Exception e) {
                    this.scene.addCutscene((Cutscene)cutscene);
                    Util.sendCrashMessage((class_1657)this.field_22787.field_1724, e);
                }
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.method_48999((class_8021)new StoryElementList(this.field_22787, this, entries, true));
    }

    private class_4185 createSettingsButton(Cutscene cutscene) {
        List<Subscene> subscenesAvailable = this.scene.getSubscenes().stream().filter(sub -> cutscene.getSubscenes().stream().noneMatch(s -> s.getName().equals(sub.getName()))).toList();
        List<Animation> animationsAvailable = this.scene.getAnimations().stream().filter(anim -> cutscene.getAnimations().stream().noneMatch(a -> a.getName().equals(anim.getName()))).toList();
        return class_4185.method_46430((class_2561)ImageFontConstants.SETTINGS, button -> {
            PickElementScreen screen = this.shiftPressed ? new PickElementScreen(this, (class_2561)Translation.message("screen.pick.cutscene.title", Translation.message("global.animations", new Object[0]), class_2561.method_43470((String)cutscene.getName())), (class_2561)Translation.message("global.animations", new Object[0]), animationsAvailable, cutscene.getAnimations(), entries -> {
                ArrayList<Animation> selectedAnimations = new ArrayList<Animation>();
                for (PickElementScreen.TransferableStorySelectionList.Entry entry : entries) {
                    Animation animation = (Animation)entry.getNarrativeEntry();
                    selectedAnimations.add(animation);
                }
                List<Animation> oldAnimations = cutscene.getAnimations();
                try {
                    cutscene.getAnimations().clear();
                    cutscene.getAnimations().addAll(selectedAnimations);
                    NarrativeCraftFile.updateCutsceneFile(this.scene);
                    this.field_22787.method_1507((class_437)new CutscenesScreen(this.scene));
                }
                catch (Exception e) {
                    cutscene.getAnimations().addAll(oldAnimations);
                    Util.sendCrashMessage((class_1657)this.field_22787.field_1724, e);
                    this.field_22787.method_1507(null);
                }
            }) : new PickElementScreen(this, (class_2561)Translation.message("screen.pick.cutscene.title", Translation.message("global.subscenes", new Object[0]), class_2561.method_43470((String)cutscene.getName())), (class_2561)Translation.message("global.subscenes", new Object[0]), subscenesAvailable, cutscene.getSubscenes(), entries -> {
                ArrayList<Subscene> selectedSubscene = new ArrayList<Subscene>();
                for (PickElementScreen.TransferableStorySelectionList.Entry entry : entries) {
                    Subscene subscene = (Subscene)entry.getNarrativeEntry();
                    selectedSubscene.add(subscene);
                }
                List<Subscene> oldSubscenes = cutscene.getSubscenes();
                try {
                    cutscene.getSubscenes().clear();
                    cutscene.getSubscenes().addAll(selectedSubscene);
                    NarrativeCraftFile.updateCutsceneFile(this.scene);
                    this.field_22787.method_1507((class_437)new CutscenesScreen(this.scene));
                }
                catch (Exception e) {
                    cutscene.getSubscenes().addAll(oldSubscenes);
                    Util.sendCrashMessage((class_1657)this.field_22787.field_1724, e);
                    this.field_22787.method_1507(null);
                }
            });
            this.field_22787.method_1507((class_437)screen);
        }).method_46432(20).method_46431();
    }

    @Override
    protected void openFolder() {
        class_156.method_668().method_60932(NarrativeCraftFile.getDataFolder(this.scene).toPath());
    }

    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 340) {
            this.settingsButton.method_47400(class_7919.method_47407((class_2561)Translation.message("screen.story_manager.animation_cutscene_link", new Object[0])));
        }
        this.shiftPressed = event.method_74239();
        return super.method_25404(event);
    }

    public boolean method_16803(class_11908 event) {
        if (event.comp_4795() == 340) {
            this.settingsButton.method_47400(class_7919.method_47407((class_2561)Translation.message("screen.story_manager.subscene_cutscene_link", new Object[0])));
        }
        this.shiftPressed = event.method_74239();
        return super.method_16803(event);
    }
}

