/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import java.lang.reflect.Type;

public class CutsceneSerializer
implements JsonSerializer<Cutscene>,
JsonDeserializer<Cutscene> {
    private final String animationsKey = "animations_name";
    private final String subscenesKey = "subscenes_name";
    private final Scene scene;

    public CutsceneSerializer(Scene scene) {
        this.scene = scene;
    }

    public JsonElement serialize(Cutscene cutscene, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new Gson().toJsonTree((Object)cutscene).getAsJsonObject();
        JsonArray subscenesArray = new JsonArray();
        for (String name : cutscene.getSubscenesName()) {
            subscenesArray.add(name);
        }
        obj.add("subscenes_name", (JsonElement)subscenesArray);
        JsonArray animationsArray = new JsonArray();
        for (String name : cutscene.getAnimationsName()) {
            animationsArray.add(name);
        }
        obj.add("animations_name", (JsonElement)animationsArray);
        return obj;
    }

    public Cutscene deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        Cutscene cutscene = (Cutscene)new Gson().fromJson(json, Cutscene.class);
        cutscene.setScene(this.scene);
        if (obj.has("subscenes_name")) {
            for (JsonElement e : obj.getAsJsonArray("subscenes_name")) {
                String subsceneName = e.getAsString();
                Subscene subscene = this.scene.getSubsceneByName(subsceneName);
                if (subscene == null) continue;
                cutscene.getSubscenes().add(subscene);
            }
        }
        if (obj.has("animations_name")) {
            for (JsonElement e : obj.getAsJsonArray("animations_name")) {
                String animationName = e.getAsString();
                Animation animation = this.scene.getAnimationByName(animationName);
                if (animation == null) continue;
                cutscene.getAnimations().add(animation);
            }
        }
        return cutscene;
    }
}

