/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.managers.PlaybackManager;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.CommandUtil;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PlaybackCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nc").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"playback").then(((LiteralArgumentBuilder)Commands.literal((String)"play").then(Commands.literal((String)"animation").then(Commands.argument((String)"animation_name", (ArgumentType)StringArgumentType.string()).suggests(PlaybackCommand::getAnimationSuggestion).executes(context -> PlaybackCommand.playAnimation((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"animation_name")))))).then(Commands.literal((String)"subscene").then(Commands.argument((String)"subscene_name", (ArgumentType)StringArgumentType.string()).suggests(PlaybackCommand::getSubscenesSuggestion).executes(context -> PlaybackCommand.playSubscene((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"subscene_name"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"stop").then(Commands.literal((String)"animation").then(Commands.argument((String)"animation_name", (ArgumentType)StringArgumentType.string()).suggests(PlaybackCommand::getAnimationsPlaying).executes(context -> PlaybackCommand.stopAnimation((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"animation_name")))))).then(Commands.literal((String)"subscene").then(Commands.argument((String)"subscene_name", (ArgumentType)StringArgumentType.string()).suggests(PlaybackCommand::getSubscenesPlaying).executes(context -> PlaybackCommand.stopSubscene((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"subscene_name"))))))).then(Commands.literal((String)"stop_all").executes(PlaybackCommand::stopAllPlayback))));
    }

    private static int playAnimation(CommandContext<CommandSourceStack> context, String animationName) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        Animation animation = playerSession.getScene().getAnimationByName(animationName);
        if (animation == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("animation.no_exists", animationName, playerSession.getScene().getName()));
            return 0;
        }
        Playback playback = new Playback(PlaybackManager.ID_INCREMENTER.incrementAndGet(), animation, (Level)((CommandSourceStack)context.getSource()).getLevel(), Environment.RECORDING, false);
        playback.start();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("playback.animation.play", animation.getName()), false);
        playerSession.getPlaybackManager().addPlayback(playback);
        return 1;
    }

    private static int playSubscene(CommandContext<CommandSourceStack> context, String subsceneName) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        Subscene subscene = playerSession.getScene().getSubsceneByName(subsceneName);
        if (subscene == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("subscene.no_exists", subsceneName, playerSession.getScene().getName()));
            return 0;
        }
        subscene.start((Level)((CommandSourceStack)context.getSource()).getLevel(), Environment.RECORDING, false);
        playerSession.getPlaybackManager().getPlaybacks().addAll(subscene.getPlaybacks());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("playback.subscene.play", subscene.getName()), false);
        return 1;
    }

    private static int stopAnimation(CommandContext<CommandSourceStack> context, String animationName) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        Animation animation = playerSession.getScene().getAnimationByName(animationName);
        if (animation == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("animation.no_exists", animationName, playerSession.getScene().getName()));
            return 0;
        }
        List<Playback> playbacks = playerSession.getPlaybackManager().getAnimationsByNamePlaying(animationName);
        if (playbacks.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("playback.animation.not_playing", animationName, playerSession.getScene().getName()));
            return 0;
        }
        for (Playback playback : playbacks) {
            playback.stop(true);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("playback.animation.stop", animation.getName()), false);
        return 1;
    }

    private static int stopSubscene(CommandContext<CommandSourceStack> context, String subsceneName) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        Subscene subscene = playerSession.getScene().getSubsceneByName(subsceneName);
        if (subscene == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("subscene.no_exists", subsceneName, playerSession.getScene().getName()));
            return 0;
        }
        if (!subscene.isPlaying()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("playback.subscene.not_playing", subsceneName, playerSession.getScene().getName()));
            return 0;
        }
        subscene.stop(true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("playback.subscene.stop", subscene.getName()), false);
        return 1;
    }

    private static int stopAllPlayback(CommandContext<CommandSourceStack> context) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        PlaybackManager playbackManager = playerSession.getPlaybackManager();
        if (playbackManager.getPlaybacksPlaying().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("playbacks.not_playing", new Object[0]));
            return 0;
        }
        playbackManager.stopAll();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("playback.stop_all", new Object[0]), false);
        return 1;
    }

    private static CompletableFuture<Suggestions> getAnimationSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return builder.buildFuture();
        }
        return CommandUtil.getNamesNarrativeEntrySuggestion(builder, playerSession.getScene().getAnimations());
    }

    private static CompletableFuture<Suggestions> getSubscenesSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return builder.buildFuture();
        }
        return CommandUtil.getNamesNarrativeEntrySuggestion(builder, playerSession.getScene().getSubscenes());
    }

    private static CompletableFuture<Suggestions> getAnimationsPlaying(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return builder.buildFuture();
        }
        ArrayList<Animation> animationPlaying = new ArrayList<Animation>();
        for (Playback playback : playerSession.getPlaybackManager().getAnimationsByNamePlaying()) {
            animationPlaying.add(playback.getAnimation());
        }
        return CommandUtil.getNamesNarrativeEntrySuggestion(builder, animationPlaying);
    }

    private static CompletableFuture<Suggestions> getSubscenesPlaying(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return builder.buildFuture();
        }
        ArrayList<Subscene> subscenePlaying = new ArrayList<Subscene>();
        for (Subscene subscene : playerSession.getScene().getSubscenes()) {
            if (!subscene.isPlaying()) continue;
            subscenePlaying.add(subscene);
        }
        return CommandUtil.getNamesNarrativeEntrySuggestion(builder, subscenePlaying);
    }
}

