/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger;

import com.mojang.datafixers.util.Pair;
import fr.loudo.narrativecraft.items.CutsceneEditItems;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;

public class KeyframeTrigger
extends Keyframe {
    private String commands;
    private int tick;

    public KeyframeTrigger(int id, int tick, String commands, KeyframeLocation keyframeLocation) {
        super(id, keyframeLocation);
        this.tick = tick;
        this.commands = commands;
    }

    @Override
    public void showKeyframe(ServerPlayer player) {
        super.showKeyframe(player);
        player.connection.send((Packet)new ClientboundSetEquipmentPacket(this.camera.getId(), List.of(new Pair((Object)EquipmentSlot.HEAD, (Object)CutsceneEditItems.trigger))));
        this.camera.setCustomNameVisible(true);
        this.camera.setCustomName((Component)Component.literal((String)"Trigger"));
        this.updateEntityData(player);
    }

    public String getCommands() {
        return this.commands;
    }

    public void setCommands(String commands) {
        this.commands = commands;
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public List<String> getCommandsToList() {
        return Arrays.stream(this.commands.split("\n")).toList();
    }
}

