/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.playback;

import fr.loudo.narrativecraft.mixin.accessor.PlayerListAccessor;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.ActionsData;
import fr.loudo.narrativecraft.narrative.recording.actions.DeathAction;
import fr.loudo.narrativecraft.narrative.recording.actions.EmoteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.PoseAction;
import fr.loudo.narrativecraft.narrative.recording.actions.SleepAction;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.platform.Services;
import fr.loudo.narrativecraft.util.FakePlayer;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Playback {
    private final int id;
    private final boolean isLooping;
    private final Animation animation;
    private final CharacterRuntime characterRuntime;
    private final Level level;
    private final Environment environment;
    private final List<PlaybackData> entityPlaybacks = new ArrayList<PlaybackData>();
    private LivingEntity masterEntity;
    private boolean isPlaying;
    private boolean hasEnded;
    private boolean isUnique;
    private int globalTick;

    public Playback(int id, Animation animation, Level level, Environment environment, boolean isLooping) {
        this.id = id;
        this.animation = animation;
        this.level = level;
        this.environment = environment;
        this.characterRuntime = new CharacterRuntime(animation.getCharacter(), animation.getSkinName(), this.masterEntity, animation.getScene());
        this.isPlaying = false;
        this.hasEnded = false;
        this.isLooping = isLooping;
        this.isUnique = false;
    }

    public void startFromStory(StoryHandler storyHandler) {
        if (storyHandler == null) {
            this.start();
            return;
        }
        CharacterRuntime characterRuntime = storyHandler.getCharacterRuntimeFromCharacter(this.getCharacter());
        if (characterRuntime == null || characterRuntime.getEntity() == null) {
            this.start();
            return;
        }
        if (this.needToRespawn(characterRuntime.getEntity().position(), this.animation.getFirstLocation().asVec3())) {
            storyHandler.killCharacter(this.animation.getCharacter());
        } else {
            this.masterEntity = characterRuntime.getEntity();
            characterRuntime.setEntity(this.masterEntity);
        }
        this.start();
    }

    public void start() {
        this.characterRuntime.getCharacterSkinController().cacheSkins();
        if (this.animation.getCharacter() == null) {
            Minecraft.getInstance().player.displayClientMessage((Component)Translation.message("animation.no_character_linked", this.animation.getName()).withStyle(ChatFormatting.RED), false);
            return;
        }
        this.globalTick = 0;
        this.isPlaying = true;
        this.hasEnded = false;
        this.entityPlaybacks.clear();
        ActionsData masterEntityData = this.animation.getActionsData().getFirst();
        Location firstLoc = masterEntityData.getLocations().getFirst();
        PlaybackData playbackData = new PlaybackData(masterEntityData, this);
        playbackData.setEntity((Entity)this.masterEntity);
        this.entityPlaybacks.add(playbackData);
        if (this.masterEntity == null) {
            this.spawnMasterEntity(firstLoc);
        }
        for (int i = 1; i < this.animation.getActionsData().size(); ++i) {
            ActionsData actionsData = this.animation.getActionsData().get(i);
            PlaybackData playbackData1 = new PlaybackData(actionsData, this);
            if (actionsData.getSpawnTick() == 0) {
                playbackData1.spawnEntity(actionsData.getLocations().getFirst());
            }
            this.entityPlaybacks.add(playbackData1);
        }
        for (PlaybackData playbackData1 : this.entityPlaybacks) {
            playbackData1.reset();
            this.actionListener(playbackData1);
        }
    }

    public void tick() {
        if (!this.isPlaying) {
            return;
        }
        for (PlaybackData playbackData : this.entityPlaybacks) {
            playbackData.tick(this.globalTick);
        }
        ++this.globalTick;
        boolean allEnded = this.entityPlaybacks.stream().allMatch(PlaybackData::hasEnded);
        if (allEnded) {
            this.finalizePlaybackCycle();
        }
        for (PlaybackData playbackData : this.entityPlaybacks) {
            this.actionListener(playbackData);
        }
    }

    public void finalizePlaybackCycle() {
        if (this.isUnique || this.environment == Environment.RECORDING) {
            this.stop(true);
            return;
        }
        if (this.isLooping) {
            this.reset();
            for (PlaybackData playbackData : this.entityPlaybacks) {
                if (playbackData.getEntity() == null) continue;
                playbackData.getActionsData().reset(playbackData.getEntity());
                ActionsData actionsData = playbackData.getActionsData();
                List<Location> movementData = actionsData.getLocations();
                if (movementData.isEmpty() || !this.needToRespawn(movementData.getFirst().asVec3(), movementData.getLast().asVec3())) continue;
                if (playbackData.getEntity().getUUID().equals(this.masterEntity.getUUID())) {
                    playbackData.killEntity();
                    this.spawnMasterEntity(movementData.getFirst());
                    continue;
                }
                playbackData.killEntity();
                playbackData.spawnEntity(movementData.getFirst());
            }
        } else {
            this.stop(false);
        }
    }

    public boolean needToRespawn(Vec3 firstPos, Vec3 secondPos) {
        return firstPos.distanceTo(secondPos) >= 0.8;
    }

    private void reset() {
        for (PlaybackData playbackData : this.entityPlaybacks) {
            playbackData.reset();
        }
        this.globalTick = 0;
    }

    public void killMasterEntity() {
        PlaybackData playbackData = this.entityPlaybacks.getFirst();
        this.masterEntity.remove(Entity.RemovalReason.KILLED);
        LivingEntity livingEntity = this.masterEntity;
        if (livingEntity instanceof FakePlayer) {
            FakePlayer fakePlayer = (FakePlayer)livingEntity;
            ((PlayerListAccessor)this.level.getServer().getPlayerList()).getPlayersByUUID().remove(fakePlayer.getUUID());
        }
        playbackData.setEntity(null);
    }

    public void respawnMasterEntity(Location position) {
        this.spawnMasterEntity(position);
    }

    public void changeLocationByTick(int newTick, boolean seamless) {
        newTick = Math.min(newTick, this.animation.getActionsData().getFirst().getLocations().size() - 1);
        int oldTick = this.globalTick;
        for (PlaybackData playbackData : this.entityPlaybacks) {
            ActionsData actionsData = playbackData.getActionsData();
            if (playbackData.getEntity() != null && playbackData.getEntity().equals((Object)this.masterEntity)) {
                Location location = actionsData.getLocations().get(newTick);
                playbackData.setLocalTick(newTick);
                if (seamless) {
                    this.moveEntitySilent((Entity)this.masterEntity, location);
                    continue;
                }
                this.killMasterEntity();
                this.spawnMasterEntity(location);
                if (newTick == 0) {
                    this.globalTick = 0;
                    this.actionListener(playbackData);
                }
                int i = 0;
                while (i < newTick) {
                    this.globalTick = i++;
                    this.actionListener(playbackData);
                }
                this.globalTick = oldTick;
                continue;
            }
            playbackData.changeLocationByTick(newTick, seamless);
        }
        for (PlaybackData playbackData : this.entityPlaybacks) {
            int tickDiff = newTick - this.globalTick;
            if (tickDiff > 0) {
                i = this.globalTick;
                while (i < newTick) {
                    this.globalTick = i++;
                    this.actionListener(playbackData);
                }
            } else {
                i = this.globalTick;
                while (i > newTick) {
                    this.globalTick = i--;
                    this.actionListenerRewind(playbackData);
                }
            }
            this.globalTick = oldTick;
        }
        this.globalTick = newTick;
        this.hasEnded = false;
    }

    public void actionListener(PlaybackData playbackData) {
        if (playbackData.getEntity() == null) {
            return;
        }
        List<Action> actionToBePlayed = playbackData.getActionsData().getActions().stream().filter(action -> this.globalTick == action.getTick()).toList();
        for (Action action2 : actionToBePlayed) {
            if (action2 instanceof EmoteAction && !Services.PLATFORM.isModLoaded("emotecraft")) continue;
            action2.execute(playbackData);
        }
    }

    public void actionListenerRewind(PlaybackData playbackData) {
        SequencedCollection<Action> actionToBePlayed = playbackData.getActionsData().getActions().stream().filter(action -> this.globalTick == action.getTick()).toList();
        actionToBePlayed = actionToBePlayed.reversed();
        for (Action action2 : actionToBePlayed) {
            if (action2 instanceof EmoteAction && !Services.PLATFORM.isModLoaded("emotecraft") || !(action2 instanceof DeathAction) && playbackData.getEntity() == null) continue;
            if (action2 instanceof PoseAction) {
                SleepAction previousSleepAction;
                PoseAction poseAction = (PoseAction)action2;
                poseAction.rewind(playbackData);
                if (poseAction.getPreviousPose() != Pose.SLEEPING || (previousSleepAction = (SleepAction)playbackData.getActionsData().getActions().stream().filter(action1 -> this.globalTick <= action2.getTick() && action1 instanceof SleepAction).toList().getLast()) == null) continue;
                previousSleepAction.execute(playbackData);
                continue;
            }
            action2.rewind(playbackData);
        }
    }

    private void spawnMasterEntity(Location loc) {
        if (this.masterEntity != null && this.masterEntity.isAlive()) {
            this.moveEntitySilent((Entity)this.masterEntity, loc);
            return;
        }
        this.masterEntity = Util.createEntityFromCharacter(this.characterRuntime.getCharacterStory(), this.level);
        this.characterRuntime.setEntity(this.masterEntity);
        this.moveEntitySilent((Entity)this.masterEntity, loc);
        this.entityPlaybacks.getFirst().setEntity((Entity)this.masterEntity);
    }

    public int getMaxTick() {
        return this.animation.getActionsData().stream().mapToInt(data -> data.getLocations().size()).max().orElse(0);
    }

    public void stop(boolean killEntity) {
        this.isPlaying = false;
        this.hasEnded = true;
        if (killEntity) {
            for (PlaybackData playbackData : this.entityPlaybacks) {
                if (playbackData.getEntity() == null) continue;
                playbackData.getActionsData().reset(playbackData.getEntity());
                playbackData.killEntity();
            }
        }
    }

    private void moveEntitySilent(Entity entity, Location location) {
        if (entity == null) {
            return;
        }
        entity.setXRot(location.pitch());
        entity.setYRot(location.yaw());
        entity.setYHeadRot(location.yaw());
        entity.setOnGround(location.onGround());
        entity.teleportTo(location.x(), location.y(), location.z());
    }

    public boolean entityInPlayback(Entity entity) {
        for (PlaybackData playbackData : this.entityPlaybacks) {
            if (playbackData.getEntity() == null || !playbackData.getEntity().getUUID().equals(entity.getUUID())) continue;
            return true;
        }
        return false;
    }

    public Entity getEntityByRecordId(int recordingId) {
        for (PlaybackData playbackData : this.entityPlaybacks) {
            if (playbackData.getActionsData().getEntityIdRecording() != recordingId) continue;
            return playbackData.getEntity();
        }
        return null;
    }

    public PlaybackData getPlaybackDataByRecordId(int recordingId) {
        for (PlaybackData playbackData : this.entityPlaybacks) {
            if (playbackData.getActionsData().getEntityIdRecording() != recordingId) continue;
            return playbackData;
        }
        return null;
    }

    public List<PlaybackData> getEntityPlaybacks() {
        return this.entityPlaybacks;
    }

    public ActionsData getMasterEntityData() {
        return this.animation.getActionsData().getFirst();
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean hasEnded() {
        return this.hasEnded;
    }

    public int getTick() {
        return this.globalTick;
    }

    public void setTick(int tick) {
        this.globalTick = tick;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
        if (playing) {
            this.hasEnded = false;
        }
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public LivingEntity getMasterEntity() {
        return this.masterEntity;
    }

    public CharacterRuntime getCharacterRuntime() {
        return this.characterRuntime;
    }

    public CharacterStory getCharacter() {
        return this.characterRuntime.getCharacterStory();
    }

    public int getId() {
        return this.id;
    }

    public Environment getEnvironnement() {
        return this.environment;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean unique) {
        this.isUnique = unique;
    }
}

