/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class MinecraftCommandInkAction
extends InkAction {
    private String command;

    public MinecraftCommandInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Command value"));
        }
        this.command = arguments.get(1);
        this.command = this.command.replace("\\{", "{");
        this.command = this.command.replace("\\}", "}");
        CommandSourceStack commandSourceStack = new CommandSourceStack(null, null, null, null, 4, null, null, NarrativeCraftMod.server, null);
        ParseResults parse = NarrativeCraftMod.server.getCommands().getDispatcher().parse(new StringReader(this.command), (Object)commandSourceStack);
        if (parse.getReader().canRead() && parse.getExceptions().size() == 1) {
            String commandError = ((CommandSyntaxException)((Object)parse.getExceptions().values().iterator().next())).getMessage();
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Command can't be executed: " + commandError));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        CommandSourceStack commandSourceStack = this.getCommandSourceStack(playerSession);
        try {
            playerSession.getPlayer().getServer().getCommands().getDispatcher().execute(this.command, (Object)commandSourceStack);
        }
        catch (CommandSyntaxException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Command can't be executed: " + e.getMessage()));
        }
        return InkActionResult.ok();
    }

    private CommandSourceStack getCommandSourceStack(PlayerSession playerSession) {
        ServerPlayer player = playerSession.getPlayer();
        CommandSource commandSource = CommandSource.NULL;
        return new CommandSourceStack(commandSource, player.position(), player.getRotationVector(), player.level(), 4, player.getName().getString(), player.getDisplayName(), player.getServer(), (Entity)player);
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

