/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.characters;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.character.CharacterType;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.screens.characters.CharacterChangePoseScreen;
import fr.loudo.narrativecraft.screens.components.ButtonListScreen;
import fr.loudo.narrativecraft.screens.components.ChangeSkinLinkScreen;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class CharacterOptionsScreen
extends ButtonListScreen {
    private final AbstractKeyframeController<? extends Keyframe> controller;
    private final CharacterRuntime characterRuntime;
    private final CharacterStoryData characterStoryData;

    public CharacterOptionsScreen(Screen lastScreen, AbstractKeyframeController<? extends Keyframe> controller, CharacterRuntime characterRuntime) {
        super(lastScreen, (Component)Component.literal((String)"Character options screen"));
        this.controller = controller;
        this.characterRuntime = characterRuntime;
        this.characterStoryData = controller.getCharacterStoryDataFromEntity((Entity)characterRuntime.getEntity());
    }

    @Override
    protected void addContents() {
        if (this.characterRuntime.getCharacterStory() == null) {
            return;
        }
        if (this.characterStoryData != null) {
            Button changeCharacterPoseButton = Button.builder((Component)Translation.message("character.change_pose", new Object[0]), button -> {
                CharacterChangePoseScreen screen = new CharacterChangePoseScreen(this, this.characterStoryData);
                this.minecraft.setScreen((Screen)screen);
            }).build();
            this.objectListScreen.addButton((AbstractWidget)changeCharacterPoseButton);
        }
        if (this.characterRuntime.getCharacterStory().getCharacterType() == CharacterType.MAIN) {
            Button changeCharacterSkinButton = Button.builder((Component)Translation.message("character.change_skin", new Object[0]), button -> {
                ChangeSkinLinkScreen screen = new ChangeSkinLinkScreen(this, this.characterRuntime, this.characterRuntime::setSkinName);
                this.minecraft.setScreen((Screen)screen);
            }).build();
            this.objectListScreen.addButton((AbstractWidget)changeCharacterSkinButton);
        }
        if (this.characterStoryData != null) {
            Button removeCharacterButton = Button.builder((Component)Translation.message("global.remove", new Object[0]), button -> {
                ConfirmScreen confirm = new ConfirmScreen(b -> {
                    if (b) {
                        NarrativeCraftMod.server.execute(() -> {
                            this.characterStoryData.kill();
                            this.controller.getCharacterStoryDataList().remove(this.characterStoryData);
                        });
                    }
                    this.minecraft.setScreen(null);
                }, (Component)Component.literal((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
                this.minecraft.setScreen((Screen)confirm);
            }).build();
            this.objectListScreen.addButton((AbstractWidget)removeCharacterButton);
        }
        if (this.objectListScreen.children().isEmpty()) {
            this.minecraft.setScreen(null);
        }
    }
}

