/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cutscene;

import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.Translation;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.Component;

public class CutsceneKeyframeEasingsScreen
extends OptionsSubScreen {
    private CutsceneEasingsList cutsceneEasingsList;
    private final CutsceneKeyframe keyframe;

    public CutsceneKeyframeEasingsScreen(Screen lastScreen, CutsceneKeyframe keyframe) {
        super(lastScreen, Minecraft.getInstance().options, (Component)Translation.message("screen.keyframe_advanced.easings", new Object[0]));
        this.keyframe = keyframe;
    }

    protected void addContents() {
        this.cutsceneEasingsList = (CutsceneEasingsList)this.layout.addToContents((LayoutElement)new CutsceneEasingsList(this.minecraft));
    }

    protected void addOptions() {
    }

    protected void repositionElements() {
        super.repositionElements();
        this.cutsceneEasingsList.updateSize(this.width, this.layout);
    }

    public void onClose() {
        CutsceneEasingsList.Entry entry = (CutsceneEasingsList.Entry)this.cutsceneEasingsList.getSelected();
        String selectedEasing = entry.easing.name();
        this.keyframe.setEasing(Easing.valueOf(selectedEasing));
        this.minecraft.setScreen(this.lastScreen);
        super.onClose();
    }

    class CutsceneEasingsList
    extends ObjectSelectionList<Entry> {
        public CutsceneEasingsList(Minecraft minecraft) {
            super(minecraft, CutsceneKeyframeEasingsScreen.this.width, CutsceneKeyframeEasingsScreen.this.height - 33 - 53, 33, 18);
            String selectedEasing = CutsceneKeyframeEasingsScreen.this.keyframe.getEasing().name();
            Arrays.stream(Easing.values()).toList().forEach(easing -> {
                Entry entry = new Entry((Easing)((Object)easing));
                this.addEntry((AbstractSelectionList.Entry)entry);
                if (selectedEasing.equals(easing.name())) {
                    this.setSelected((AbstractSelectionList.Entry)entry);
                }
            });
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((Entry)this.getSelected()));
            }
        }

        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final Easing easing;

            public Entry(Easing easing) {
                this.easing = easing;
            }

            public void render(GuiGraphics p_345300_, int p_345469_, int p_345328_, int p_345700_, int p_345311_, int p_345185_, int p_344805_, int p_345963_, boolean p_345912_, float p_346091_) {
                p_345300_.drawCenteredString(CutsceneKeyframeEasingsScreen.this.font, this.easing.name(), CutsceneEasingsList.this.width / 2, p_345328_ + p_345185_ / 2 - 4, -1);
            }

            public boolean keyPressed(int p_346403_, int p_345881_, int p_345858_) {
                if (CommonInputs.selected((int)p_346403_)) {
                    this.select();
                    CutsceneKeyframeEasingsScreen.this.onClose();
                    return true;
                }
                return super.keyPressed(p_346403_, p_345881_, p_345858_);
            }

            public boolean mouseClicked(double p_344965_, double p_345385_, int p_345080_) {
                this.select();
                return super.mouseClicked(p_344965_, p_345385_, p_345080_);
            }

            private void select() {
                CutsceneEasingsList.this.setSelected((AbstractSelectionList.Entry)this);
            }

            public Component getNarration() {
                return Component.literal((String)this.easing.name());
            }
        }
    }
}

