/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.options;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.options.NarrativeWorldOption;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class WorldOptionsScreen
extends StoryElementScreen {
    private final NarrativeWorldOption worldOption = NarrativeCraftMod.getInstance().getNarrativeWorldOption();
    private final Screen lastScreen;

    public WorldOptionsScreen(Screen lastScreen) {
        super((Component)Translation.message("screen.world_options.title", new Object[0]));
        this.lastScreen = lastScreen;
    }

    public void onClose() {
        NarrativeCraftFile.updateWorldOptions(this.worldOption);
        this.minecraft.setScreen(this.lastScreen);
    }

    @Override
    protected void addTitle() {
        this.linearlayout = ((LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.horizontal())).spacing(8);
        this.linearlayout.defaultCellSetting().alignVerticallyMiddle();
        this.linearlayout.addChild((LayoutElement)new StringWidget(this.title, this.font));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = List.of(this.createToggleButton(() -> this.worldOption.finishedStory, val -> {
            this.worldOption.finishedStory = val;
        }, "screen.world_options.finished_story"), this.createToggleButton(() -> this.worldOption.showMainScreen, val -> {
            this.worldOption.showMainScreen = val;
        }, "screen.world_options.show_main_screen"), this.createToggleButton(() -> this.worldOption.showCreditsScreen, val -> {
            this.worldOption.showCreditsScreen = val;
        }, "screen.world_options.show_credits_screen"));
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }

    private StoryElementList.StoryEntryData createToggleButton(BooleanSupplier getter, Consumer<Boolean> setter, String translationKey) {
        Button button = Button.builder((Component)Translation.message(translationKey, this.yesOrNo(getter.getAsBoolean())), b -> {
            boolean newValue = !getter.getAsBoolean();
            setter.accept(newValue);
            b.setMessage((Component)Translation.message(translationKey, this.yesOrNo(newValue)));
        }).build();
        return new StoryElementList.StoryEntryData(button);
    }

    @Override
    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, p_345997_ -> this.onClose()).width(200).build());
    }

    @Override
    protected void openFolder() {
    }

    private Component yesOrNo(boolean b) {
        return b ? CommonComponents.GUI_YES : CommonComponents.GUI_NO;
    }
}

