/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.scene;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.chapter.ChaptersScreen;
import fr.loudo.narrativecraft.screens.storyManager.scene.EditScreenSceneAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ScenesScreen
extends StoryElementScreen {
    private final Chapter chapter;

    public ScenesScreen(Chapter chapter) {
        super((Component)Translation.message("screen.story_manager.scene_list", chapter.getIndex()));
        this.chapter = chapter;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<Scene> screen = new EditInfoScreen<Scene>(this, null, new EditScreenSceneAdapter(this.chapter));
            this.minecraft.setScreen(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, p_345997_ -> this.onClose()).width(200).build());
    }

    public void onClose() {
        ChaptersScreen screen = new ChaptersScreen();
        this.minecraft.setScreen((Screen)screen);
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.chapter.getSortedSceneList().stream().map(scene -> {
            Button button = Button.builder((Component)Component.literal((String)scene.getName()), b -> this.minecraft.setScreen((Screen)new ScenesMenuScreen((Scene)scene))).build();
            return new StoryElementList.StoryEntryData(button, () -> this.minecraft.setScreen(new EditInfoScreen<Scene>(this, (Scene)scene, new EditScreenSceneAdapter(this.chapter))), () -> {
                try {
                    this.chapter.removeScene((Scene)scene);
                    NarrativeCraftFile.deleteSceneDirectory(scene);
                    if (scene.getRank() == 1 && this.chapter.getSortedSceneList().size() > 1) {
                        NarrativeCraftFile.updateMasterSceneKnot(this.chapter.getSortedSceneList().getFirst());
                    }
                    this.minecraft.setScreen((Screen)new ScenesScreen(this.chapter));
                }
                catch (Exception e) {
                    this.chapter.addScene((Scene)scene);
                    this.chapter.setSceneRank((Scene)scene, scene.getRank());
                    Util.sendCrashMessage((Player)this.minecraft.player, e);
                    this.minecraft.setScreen(null);
                }
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.getPlatform().openPath(NarrativeCraftFile.getScenesFolder(this.chapter).toPath());
    }
}

