/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.managers.CharacterManager;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.serialization.ActionSerializer;
import java.lang.reflect.Type;

public class AnimationSerializer
implements JsonSerializer<Animation>,
JsonDeserializer<Animation> {
    private final String characterKey = "character_name";
    private final Scene scene;

    public AnimationSerializer(Scene scene) {
        this.scene = scene;
    }

    public JsonElement serialize(Animation animation, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new Gson().toJsonTree((Object)animation).getAsJsonObject();
        CharacterStory characterStory = animation.getCharacter();
        if (characterStory == null) {
            return obj;
        }
        obj.addProperty("character_name", characterStory.getName());
        return obj;
    }

    public Animation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Animation animation = (Animation)new GsonBuilder().registerTypeAdapter(Action.class, (Object)new ActionSerializer()).create().fromJson(json, Animation.class);
        animation.setScene(this.scene);
        CharacterManager characterManager = NarrativeCraftMod.getInstance().getCharacterManager();
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("character_name")) {
            String characterName = jsonObject.get("character_name").getAsString();
            CharacterStory characterStory = characterManager.getCharacterByName(characterName);
            if (characterStory == null && (characterStory = this.scene.getNpcByName(characterName)) == null) {
                return animation;
            }
            animation.setCharacter(characterStory);
        }
        return animation;
    }
}

