/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.story.StorySave;
import fr.loudo.narrativecraft.serialization.CharacterStoryDataSerializer;
import java.lang.reflect.Type;

public class StorySaveSerializer
implements JsonSerializer<StorySave>,
JsonDeserializer<StorySave> {
    private final String chapterKey = "chapter_index";
    private final String sceneKey = "scene_name";

    public JsonElement serialize(StorySave save, Type type, JsonSerializationContext context) {
        Gson gson = new GsonBuilder().registerTypeAdapter(CharacterStoryData.class, (Object)new CharacterStoryDataSerializer(save.getScene())).create();
        JsonObject obj = gson.toJsonTree((Object)save).getAsJsonObject();
        obj.addProperty("chapter_index", (Number)save.getChapter().getIndex());
        obj.addProperty("scene_name", save.getScene().getName());
        return obj;
    }

    public StorySave deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        Chapter chapter = null;
        if (obj.has("chapter_index")) {
            int index = obj.get("chapter_index").getAsInt();
            chapter = NarrativeCraftMod.getInstance().getChapterManager().getChapterByIndex(index);
        }
        Scene scene = null;
        if (obj.has("scene_name") && chapter != null) {
            String sceneName = obj.get("scene_name").getAsString();
            scene = chapter.getSceneByName(sceneName);
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(CharacterStoryData.class, (Object)new CharacterStoryDataSerializer(scene)).create();
        StorySave save = (StorySave)gson.fromJson(json, StorySave.class);
        save.setScene(scene);
        save.setChapter(chapter);
        return save;
    }
}

