/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.util;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;

public class ScreenUtils {
    public static StringWidget text(Component text, Font font, int x, int y) {
        return new StringWidget(x, y, font.width(text.getVisualOrderText()), 9, text, font);
    }

    public static StringWidget text(Component text, Font font, int x, int y, int color) {
        StringWidget stringWidget = new StringWidget(x, y, font.width(text.getVisualOrderText()), 9, text, font);
        stringWidget.setColor(color);
        return stringWidget;
    }

    public static void sendToast(Component name, Component description) {
        Minecraft.getInstance().getToastManager().addToast((Toast)new SystemToast(SystemToast.SystemToastId.NARRATOR_TOGGLE, name, description));
    }

    public static enum Align {
        VERTICAL,
        HORIZONTAL;

    }

    public static class MultilineLabelBox {
        private final StringWidget stringWidget;
        private final MultiLineEditBox multiLineEditBox;

        public MultilineLabelBox(Component text, Font font, int width, int height, int x, int y, Component placeholder) {
            this.stringWidget = ScreenUtils.text(text, font, x, y);
            this.multiLineEditBox = MultiLineEditBox.builder().setPlaceholder(placeholder).setX(x).setY(y + this.stringWidget.getHeight() + 5).build(font, width, height, (Component)Component.literal((String)""));
        }

        public void setPosition(int x, int y) {
            this.stringWidget.setPosition(x, y);
            this.multiLineEditBox.setPosition(x, y += this.stringWidget.getHeight() + 5);
        }

        public StringWidget getStringWidget() {
            return this.stringWidget;
        }

        public MultiLineEditBox getMultiLineEditBox() {
            return this.multiLineEditBox;
        }
    }

    public static class LabelBox {
        private final StringWidget stringWidget;
        private final EditBox editBox;
        private final Align align;

        public LabelBox(Component text, Font font, int width, int height, int x, int y, Align align) {
            int yStringWidget = y;
            if (align == Align.HORIZONTAL) {
                Objects.requireNonNull(font);
                yStringWidget = (y += height / 2) - 9 / 2;
            }
            this.stringWidget = ScreenUtils.text(text, font, x, yStringWidget);
            if (align == Align.HORIZONTAL) {
                x = this.stringWidget.getX() + this.stringWidget.getWidth() + 5;
                y -= height / 2;
            } else if (align == Align.VERTICAL) {
                Objects.requireNonNull(font);
                y += 9 + 5;
            }
            this.editBox = new EditBox(font, x, y, width, height, (Component)Component.literal((String)(String.valueOf(text) + " value")));
            this.align = align;
        }

        public void setPosition(int x, int y) {
            if (this.align == Align.HORIZONTAL) {
                this.stringWidget.setPosition(x, y + this.editBox.getHeight() / 2 - this.stringWidget.getHeight() / 2);
            } else if (this.align == Align.VERTICAL) {
                this.stringWidget.setPosition(x, y);
            }
            if (this.align == Align.HORIZONTAL) {
                x += this.stringWidget.getWidth() + 5;
            } else if (this.align == Align.VERTICAL) {
                y = this.stringWidget.getY() + this.stringWidget.getHeight() + 5;
            }
            this.editBox.setPosition(x, y);
        }

        public StringWidget getStringWidget() {
            return this.stringWidget;
        }

        public EditBox getEditBox() {
            return this.editBox;
        }
    }
}

