/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.util;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.mixin.accessor.FontAccessor;
import fr.loudo.narrativecraft.mixin.accessor.PlayerAccessor;
import fr.loudo.narrativecraft.mixin.accessor.PlayerListAccessor;
import fr.loudo.narrativecraft.mixin.invoker.FontInvoker;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.platform.Services;
import fr.loudo.narrativecraft.util.FakePlayer;
import fr.loudo.narrativecraft.util.Translation;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;

public class Util {
    public static final String REGEX_FLOAT = "^-?\\d*(\\.\\d*)?$";
    public static final String REGEX_FLOAT_ONLY_POSITIVE = "^\\d*(\\.\\d*)?$";
    public static final String REGEX_INT = "^\\d*$";
    public static final String REGEX_NO_SPECIAL_CHARACTERS = "[a-zA-Z0-9 _-]*";

    public static String snakeCase(String value) {
        return String.join((CharSequence)"_", value.toLowerCase().split(" "));
    }

    public static void sendCrashMessage(Player player, Exception exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = "";
        }
        String finalMessage = message;
        player.displayClientMessage((Component)Translation.message("crash.global-message", new Object[0]).withStyle(ChatFormatting.RED).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)finalMessage)))), false);
        NarrativeCraftMod.LOGGER.error("Unexpected error occurred on NarrativeCraft: ", (Throwable)exception);
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            player.displayClientMessage((Component)Component.literal((String)("-- " + finalMessage)).withStyle(ChatFormatting.RED), false);
        }
    }

    public static CompoundTag nbtFromString(String nbtString) throws CommandSyntaxException {
        return TagParser.parseCompoundAsArgument((StringReader)new StringReader(nbtString));
    }

    public static BlockState getBlockStateFromData(String data, RegistryAccess registry) {
        try {
            CompoundTag compoundTag = Util.nbtFromString(data);
            return NbtUtils.readBlockState((HolderGetter)registry.lookupOrThrow(Registries.BLOCK), (CompoundTag)compoundTag);
        }
        catch (CommandSyntaxException ignored) {
            return null;
        }
    }

    public static ValueInput valueInputFromCompoundTag(RegistryAccess registryAccess, String nbtString) throws CommandSyntaxException {
        return TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)registryAccess, (CompoundTag)Util.nbtFromString(nbtString));
    }

    public static Tag getItemTag(ItemStack itemStack, RegistryAccess registryAccess) {
        CompoundTag tag;
        RegistryOps ops = registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        try {
            tag = (Tag)ItemStack.CODEC.encodeStart((DynamicOps)ops, (Object)itemStack).getOrThrow();
        }
        catch (Exception exception) {
            tag = new CompoundTag();
        }
        return tag;
    }

    public static CompoundTag tagFromIdAndComponents(Item item, String data) {
        CompoundTag tag = new CompoundTag();
        try {
            tag.put("components", (Tag)Util.nbtFromString(data));
        }
        catch (CommandSyntaxException e) {
            return null;
        }
        tag.put("id", (Tag)StringTag.valueOf((String)BuiltInRegistries.ITEM.getKey((Object)item).toString()));
        tag.put("count", (Tag)IntTag.valueOf((int)1));
        return tag;
    }

    public static ItemStack generateItemStackFromNBT(CompoundTag compoundTag, RegistryAccess registryAccess) {
        RegistryOps ops = registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (compoundTag == null) {
            return ItemStack.EMPTY;
        }
        try {
            return (ItemStack)ItemStack.CODEC.parse((DynamicOps)ops, (Object)compoundTag).getOrThrow();
        }
        catch (Exception e) {
            return ItemStack.EMPTY;
        }
    }

    public static void addFakePlayerUUID(FakePlayer fakePlayer) {
        if (NarrativeCraftMod.server == null) {
            return;
        }
        ((PlayerListAccessor)NarrativeCraftMod.server.getPlayerList()).getPlayersByUUID().put(fakePlayer.getUUID(), fakePlayer);
    }

    public static void removeFakePlayerUUID(FakePlayer fakePlayer) {
        if (NarrativeCraftMod.server == null) {
            return;
        }
        ((PlayerListAccessor)NarrativeCraftMod.server.getPlayerList()).getPlayersByUUID().remove(fakePlayer.getUUID());
    }

    public static boolean isSameEntity(Entity entity1, Entity entity2) {
        if (entity1 == null || entity2 == null) {
            return false;
        }
        return entity1.getUUID().equals(entity2.getUUID());
    }

    public static boolean isSamePlayer(ServerPlayer player1, ServerPlayer player2) {
        if (player1 == null || player2 == null) {
            return false;
        }
        return player1.getUUID().equals(player2.getUUID());
    }

    public static LivingEntity createEntityFromCharacter(CharacterStory characterStory, Level level) {
        FakePlayer entity;
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), characterStory.getName());
        if (BuiltInRegistries.ENTITY_TYPE.getId(characterStory.getEntityType()) == BuiltInRegistries.ENTITY_TYPE.getId((Object)EntityType.PLAYER)) {
            entity = new FakePlayer((ServerLevel)level, gameProfile);
            entity.getEntityData().set(PlayerAccessor.getDATA_PLAYER_MODE_CUSTOMISATION(), (Object)127);
        } else {
            entity = (LivingEntity)characterStory.getEntityType().create(level, EntitySpawnReason.MOB_SUMMONED);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.setNoAi(true);
            }
        }
        if (entity instanceof FakePlayer) {
            FakePlayer fakePlayer = entity;
            ((PlayerListAccessor)level.getServer().getPlayerList()).getPlayersByUUID().put(fakePlayer.getUUID(), fakePlayer);
            level.getServer().getPlayerList().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)fakePlayer));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.addNewPlayer((ServerPlayer)fakePlayer);
            }
            Util.addFakePlayerUUID(fakePlayer);
        } else {
            level.addFreshEntity((Entity)entity);
        }
        return entity;
    }

    public static void disconnectPlayer(Minecraft minecraft) {
        PauseScreen.disconnectFromWorld((Minecraft)minecraft, (Component)ClientLevel.DEFAULT_QUIT_MESSAGE);
    }

    public static float getLetterWidth(int letterCode, Minecraft minecraft) {
        Style style = Style.EMPTY;
        FontSet fontset = ((FontInvoker)minecraft.font).callGetFontSet(style.getFont());
        GlyphInfo glyph = fontset.getGlyphInfo(letterCode, ((FontAccessor)minecraft.font).getFilterFishyGlyphs());
        boolean bold = style.isBold();
        return glyph.getAdvance(bold);
    }

    public static int[] getImageResolution(ResourceLocation resourceLocation) {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        Optional resource = resourceManager.getResource(resourceLocation);
        if (resource.isPresent()) {
            int[] nArray;
            block9: {
                InputStream stream = ((Resource)resource.get()).open();
                try {
                    BufferedImage image = ImageIO.read(stream);
                    int width = image.getWidth();
                    int height = image.getHeight();
                    nArray = new int[]{width, height};
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                stream.close();
            }
            return nArray;
        }
        return null;
    }

    public static int getDynamicHeight(int[] resolution, int newWidth) {
        float ratio = (float)resolution[1] / (float)resolution[0];
        return Math.round(ratio * (float)newWidth);
    }

    public static boolean resourceExists(ResourceLocation resourceLocation) {
        return Minecraft.getInstance().getResourceManager().getResource(resourceLocation).isPresent();
    }
}

