/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.events;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.commands.RecordCommand;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.items.CutsceneEditItems;
import fr.loudo.narrativecraft.managers.PlayerSessionManager;
import fr.loudo.narrativecraft.managers.RecordingManager;
import fr.loudo.narrativecraft.narrative.NarrativeEntryInit;
import fr.loudo.narrativecraft.narrative.recording.Recording;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.mainScreen.MainScreen;
import fr.loudo.narrativecraft.util.FakePlayer;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class OnPlayerServerConnection {
    public static void playerJoin(ServerPlayer player) {
        if (player instanceof FakePlayer) {
            return;
        }
        OnPlayerServerConnection.initSession(player);
        NarrativeCraftMod.getInstance().setNarrativeWorldOption(NarrativeCraftFile.loadWorldOptions());
        NarrativeCraftMod.getInstance().setNarrativeClientOptions(NarrativeCraftFile.loadUserOptions());
        if (player.hasPermissions(2) && NarrativeEntryInit.hasError) {
            player.sendSystemMessage((Component)Translation.message("crash.narrative-data", new Object[0]).withStyle(ChatFormatting.RED));
        }
        CutsceneEditItems.init(player.registryAccess());
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)player);
        if (NarrativeCraftMod.getInstance().getNarrativeWorldOption().showMainScreen) {
            MainScreen mainScreen = new MainScreen(playerSession, false, false);
            Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen((Screen)mainScreen));
        }
    }

    public static void playerLeave(ServerPlayer player) {
        if (player instanceof FakePlayer) {
            return;
        }
        OnPlayerServerConnection.clearSession(player);
        RecordCommand.playerTryingOverride.remove(player);
        RecordingManager recordingManager = NarrativeCraftMod.getInstance().getRecordingManager();
        Recording recording = recordingManager.getRecording((Entity)player);
        if (recording != null && recording.isRecording()) {
            recording.stop();
        }
        recordingManager.removeRecording(recording);
    }

    private static void initSession(ServerPlayer player) {
        PlayerSession playerSession = new PlayerSession(player);
        NarrativeCraftMod.getInstance().getPlayerSessionManager().addSession(playerSession);
    }

    private static void clearSession(ServerPlayer player) {
        PlayerSessionManager playerSessionManager = NarrativeCraftMod.getInstance().getPlayerSessionManager();
        PlayerSession playerSession = playerSessionManager.getSessionByPlayer((Player)player);
        if (playerSession == null) {
            return;
        }
        playerSessionManager.removeSession(playerSession);
    }
}

