/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.options.NarrativeWorldOption;
import fr.loudo.narrativecraft.util.Translation;
import java.io.File;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelSummary;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldSelectionList.WorldListEntry.class})
public abstract class WorldSelectionListMixin {
    @Shadow
    @Final
    private LevelSummary summary;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private Screen screen;

    @Shadow
    public abstract void joinWorld();

    @Inject(method={"joinWorld"}, at={@At(value="HEAD")}, cancellable=true)
    private void narrativecraft$joinWorld(CallbackInfo ci) {
        NarrativeWorldOption worldOption = NarrativeCraftFile.getNarrativeCraftWorldVersion(this.summary.getLevelId(), SharedConstants.getCurrentVersion().name());
        if (worldOption == null) {
            return;
        }
        if (worldOption.stringMcVersion == null) {
            return;
        }
        if (!SharedConstants.getCurrentVersion().name().equals(worldOption.stringMcVersion)) {
            ConfirmScreen confirmScreen = new ConfirmScreen(b -> {
                if (b) {
                    File worldOptionFile = NarrativeCraftFile.getWorldOptionFile(this.summary.getLevelId());
                    worldOption.stringMcVersion = SharedConstants.getCurrentVersion().name();
                    NarrativeCraftFile.updateWorldOptions(worldOptionFile, worldOption);
                    this.joinWorld();
                } else {
                    this.minecraft.setScreen(this.screen);
                }
            }, (Component)Component.literal((String)""), (Component)Translation.message("screen.nc_incompatible", new Object[0]));
            this.minecraft.setScreen((Screen)confirmScreen);
            ci.cancel();
        }
    }
}

