/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer2D;
import fr.loudo.narrativecraft.narrative.dialog.animation.DialogArrowSkip;
import fr.loudo.narrativecraft.narrative.dialog.animation.DialogScrollText;
import fr.loudo.narrativecraft.narrative.story.text.ParsedDialog;
import fr.loudo.narrativecraft.util.Easing;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public class DialogRenderer {
    protected final Minecraft minecraft;
    protected double dialogTransitionTime = 0.5;
    protected double dialogAppearTime = 0.2;
    protected final DialogScrollText dialogScrollText;
    protected DialogArrowSkip dialogArrowSkip;
    protected String text;
    protected float width;
    protected float totalWidth;
    protected float oldWidth;
    protected float oldTotalWidth;
    protected float height;
    protected float totalHeight;
    protected float oldHeight;
    protected float oldTotalHeight;
    protected float paddingX;
    protected float paddingY;
    protected float oldScale;
    protected float scale;
    protected float letterSpacing;
    protected float gap;
    protected int backgroundColor;
    protected int textColor;
    protected int currentTick;
    protected int totalTick;
    protected int totalTickAutoSkip;
    protected boolean noSkip;
    protected boolean dialogStarting;
    protected boolean dialogStopping;
    protected boolean dialogAutoSkip;
    protected boolean dialogAutoSkipping;
    protected Runnable runDialogStopped;
    protected Runnable runDialogAutoSkipped;

    public DialogRenderer(String text, float width, float paddingX, float paddingY, float scale, float letterSpacing, float gap, int backgroundColor, int textColor) {
        this.text = text;
        this.width = width;
        this.paddingX = paddingX;
        this.paddingY = paddingY + 5.0f;
        this.scale = scale;
        this.letterSpacing = letterSpacing;
        this.gap = gap;
        this.backgroundColor = backgroundColor;
        this.textColor = textColor;
        this.minecraft = Minecraft.getInstance();
        this.dialogScrollText = new DialogScrollText(this, this.minecraft);
        this.dialogArrowSkip = new DialogArrowSkip(this, 2.5f, 2.5f, -5.0f, -10.0f, -1);
        this.initMeasures();
        this.dialogScrollText.reset();
    }

    public DialogRenderer(String text, DialogData dialogData) {
        this(text, dialogData.getWidth(), dialogData.getPaddingX(), dialogData.getPaddingY(), dialogData.getScale(), dialogData.getLetterSpacing(), dialogData.getGap(), dialogData.getBackgroundColor(), dialogData.getTextColor());
    }

    private void initMeasures() {
        Objects.requireNonNull(this.minecraft.font);
        this.height = 9 * this.dialogScrollText.getLines().size();
        this.totalHeight = this.height + (float)(this.dialogScrollText.getLines().size() - 1) * this.gap + 2.0f * this.paddingY;
        float widthLongestLine = (float)this.minecraft.font.width(this.dialogScrollText.getLongerTextLine()) + (float)(this.dialogScrollText.getLongerTextLine().length() - 1) * this.letterSpacing;
        this.totalWidth = widthLongestLine / 2.0f + 2.0f * this.paddingX;
    }

    public void tick() {
        if (this.currentTick < this.totalTick || this.dialogAutoSkip && this.currentTick < this.totalTickAutoSkip) {
            ++this.currentTick;
        }
        if (this.dialogStopping) {
            if (this.currentTick >= this.totalTick) {
                this.runDialogStopped.run();
            }
        } else if (this.dialogAutoSkip && this.dialogAutoSkipping && this.currentTick >= this.totalTickAutoSkip) {
            this.runDialogAutoSkipped.run();
        }
        this.dialogScrollText.tick();
        this.dialogArrowSkip.tick();
    }

    public void render(PoseStack poseStack, float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
    }

    public void update() {
        this.dialogStarting = false;
        this.dialogStopping = false;
        this.totalTick = (int)(this.dialogTransitionTime * 20.0);
        this.currentTick = this.oldWidth == this.totalWidth && this.oldHeight == this.totalHeight && this.oldScale == this.scale || this instanceof DialogRenderer2D ? this.totalTick : 0;
        this.dialogArrowSkip.stop();
        this.dialogAutoSkipping = false;
    }

    public void start() {
        this.dialogStarting = true;
        this.dialogStopping = false;
        this.totalTick = (int)(this.dialogAppearTime * 20.0);
        this.currentTick = 0;
        this.dialogArrowSkip.stop();
        this.dialogAutoSkipping = false;
    }

    public void stop() {
        this.dialogStarting = false;
        this.dialogStopping = true;
        this.totalTick = (int)(this.dialogAppearTime * 20.0);
        this.currentTick = 0;
        this.dialogArrowSkip.stop();
        this.dialogAutoSkipping = false;
    }

    public void autoSkipAt(double seconds) {
        if (seconds == 0.0) {
            return;
        }
        this.dialogAutoSkip = true;
        this.totalTickAutoSkip = (int)(seconds * 20.0);
    }

    public void stopAutoSkip() {
        this.dialogAutoSkip = false;
        this.dialogAutoSkipping = false;
        this.totalTickAutoSkip = 0;
    }

    public boolean isAnimating() {
        return this.currentTick < this.totalTick;
    }

    public DialogScrollText getDialogScrollText() {
        return this.dialogScrollText;
    }

    public float getInterpolatedWidth(float partialTick) {
        return (float)Mth.lerp((double)Easing.SMOOTH.interpolate(this.t(partialTick)), (double)this.oldTotalWidth, (double)this.totalWidth);
    }

    public float getInterpolatedHeight(float partialTick) {
        return (float)Mth.lerp((double)Easing.SMOOTH.interpolate(this.t(partialTick)), (double)this.oldTotalHeight, (double)this.totalHeight);
    }

    protected double t(float partialTick) {
        return Math.clamp((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), 0.0, 1.0);
    }

    public double getDialogTransitionTime() {
        return this.dialogTransitionTime;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        ParsedDialog parsedDialog = ParsedDialog.parse(text);
        this.dialogScrollText.setText(parsedDialog.cleanedText());
        this.initMeasures();
        this.dialogScrollText.reset();
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
        ParsedDialog parsedDialog = ParsedDialog.parse(this.text);
        this.dialogScrollText.setText(parsedDialog.cleanedText());
        this.initMeasures();
        this.dialogScrollText.reset();
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
        this.initMeasures();
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public float getTotalWidth() {
        return this.totalWidth;
    }

    public float getPaddingX() {
        return this.paddingX;
    }

    public void setPaddingX(float paddingX) {
        this.paddingX = paddingX;
    }

    public float getPaddingY() {
        return this.paddingY;
    }

    public void setPaddingY(float paddingY) {
        this.paddingY = paddingY + 5.0f;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getLetterSpacing() {
        return this.letterSpacing;
    }

    public void setLetterSpacing(float letterSpacing) {
        this.letterSpacing = letterSpacing;
    }

    public float getGap() {
        return this.gap;
    }

    public void setGap(float gap) {
        this.gap = gap;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public boolean isNoSkip() {
        return this.noSkip;
    }

    public void setNoSkip(boolean noSkip) {
        this.noSkip = noSkip;
    }

    public boolean isDialogStarting() {
        return this.dialogStarting;
    }

    public void setDialogStarting(boolean dialogStarting) {
        this.dialogStarting = dialogStarting;
    }

    public boolean isDialogStopping() {
        return this.dialogStopping;
    }

    public void setDialogStopping(boolean dialogStopping) {
        this.dialogStopping = dialogStopping;
    }

    public Runnable getRunDialogStopped() {
        return this.runDialogStopped;
    }

    public void setRunDialogStopped(Runnable runDialogStopped) {
        this.runDialogStopped = runDialogStopped;
    }

    public void setRunDialogAutoSkipped(Runnable runDialogAutoSkipped) {
        this.runDialogAutoSkipped = runDialogAutoSkipped;
    }

    public int getTotalTickAutoSkip() {
        return this.totalTickAutoSkip;
    }

    public boolean isDialogAutoSkip() {
        return this.dialogAutoSkip;
    }
}

