/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class StoryElementList
extends ContainerObjectSelectionList<Entry> {
    public StoryElementList(Minecraft minecraft, Screen screen, List<StoryEntryData> entriesData, boolean editButton) {
        super(minecraft, 240, screen.width, screen.height, 25);
        for (StoryEntryData data : entriesData) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(data, screen, editButton));
        }
    }

    public static class StoryEntryData {
        public final Button mainButton;
        public List<Button> extraButtons;
        public Runnable onDelete;
        public Runnable onUpdate;

        public StoryEntryData(Button mainButton, List<Button> extraButtons, Runnable onUpdate, Runnable onDelete) {
            this.mainButton = mainButton;
            this.extraButtons = extraButtons;
            this.onUpdate = onUpdate;
            this.onDelete = onDelete;
        }

        public StoryEntryData(Button mainButton, Runnable onUpdate, Runnable onDelete) {
            this.mainButton = mainButton;
            this.onUpdate = onUpdate;
            this.onDelete = onDelete;
        }

        public StoryEntryData(Button mainButton) {
            this.mainButton = mainButton;
        }
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final int gap = 5;
        private final Button mainButton;
        private final List<Button> buttons;
        private final Screen screen;

        public Entry(StoryEntryData data, Screen screen, boolean editButton) {
            this.screen = screen;
            this.mainButton = data.mainButton;
            this.buttons = new ArrayList<Button>();
            this.buttons.add(this.mainButton);
            if (data.onUpdate != null && editButton) {
                this.buttons.add(this.createEditButton(data.onUpdate));
                this.buttons.add(this.createRemoveButton(data.onDelete));
            }
            if (data.extraButtons != null) {
                data.extraButtons.forEach(button -> button.setWidth(20));
                this.buttons.addAll(data.extraButtons);
            }
        }

        private Button createEditButton(Runnable onUpdate) {
            return Button.builder((Component)ImageFontConstants.EDIT, btn -> onUpdate.run()).width(20).build();
        }

        private Button createRemoveButton(Runnable onDelete) {
            return Button.builder((Component)ImageFontConstants.REMOVE, btn -> {
                ConfirmScreen confirm = new ConfirmScreen(b -> {
                    if (b) {
                        onDelete.run();
                    } else {
                        Minecraft.getInstance().setScreen(this.screen);
                    }
                }, (Component)Component.literal((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
                Minecraft.getInstance().setScreen((Screen)confirm);
            }).width(20).build();
        }

        public void renderContent(GuiGraphics guiGraphics, int i, int i1, boolean b, float v) {
            int totalWidth = this.buttons.stream().mapToInt(AbstractWidget::getWidth).sum() + (this.buttons.size() - 1) * 5;
            int x = this.screen.width / 2 - totalWidth / 2;
            if (this.buttons.size() > 1) {
                x -= 5;
            }
            for (Button button : this.buttons) {
                button.setPosition(x, this.getContentY());
                button.render(guiGraphics, i, i1, v);
                x += button.getWidth() + 5;
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.buttons;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.buttons;
        }
    }
}

