/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cutscene;

import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.Translation;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class CutsceneKeyframeEasingsScreen
extends OptionsSubScreen {
    private CutsceneEasingsList cutsceneEasingsList;
    private final CutsceneKeyframe keyframe;

    public CutsceneKeyframeEasingsScreen(Screen lastScreen, CutsceneKeyframe keyframe) {
        super(lastScreen, Minecraft.getInstance().options, (Component)Translation.message("screen.keyframe_advanced.easings", new Object[0]));
        this.keyframe = keyframe;
    }

    protected void addContents() {
        this.cutsceneEasingsList = (CutsceneEasingsList)this.layout.addToContents((LayoutElement)new CutsceneEasingsList(this.minecraft));
    }

    protected void addOptions() {
    }

    protected void repositionElements() {
        super.repositionElements();
        this.cutsceneEasingsList.updateSize(this.width, this.layout);
    }

    public void onClose() {
        CutsceneEasingsList.Entry entry = (CutsceneEasingsList.Entry)this.cutsceneEasingsList.getSelected();
        String selectedEasing = entry.easing.name();
        this.keyframe.setEasing(Easing.valueOf(selectedEasing));
        this.minecraft.setScreen(this.lastScreen);
        super.onClose();
    }

    class CutsceneEasingsList
    extends ObjectSelectionList<Entry> {
        public CutsceneEasingsList(Minecraft minecraft) {
            super(minecraft, CutsceneKeyframeEasingsScreen.this.width, CutsceneKeyframeEasingsScreen.this.height - 33 - 53, 33, 18);
            String selectedEasing = CutsceneKeyframeEasingsScreen.this.keyframe.getEasing().name();
            Arrays.stream(Easing.values()).toList().forEach(easing -> {
                Entry entry = new Entry((Easing)((Object)easing));
                this.addEntry((AbstractSelectionList.Entry)entry);
                if (selectedEasing.equals(easing.name())) {
                    this.setSelected((AbstractSelectionList.Entry)entry);
                }
            });
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((Entry)this.getSelected()));
            }
        }

        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final Easing easing;

            public Entry(Easing easing) {
                this.easing = easing;
            }

            public void renderContent(GuiGraphics guiGraphics, int i, int i1, boolean b, float v) {
                guiGraphics.drawCenteredString(CutsceneKeyframeEasingsScreen.this.font, this.easing.name(), CutsceneEasingsList.this.width / 2, this.getContentYMiddle() - 4, -1);
            }

            public boolean keyPressed(KeyEvent event) {
                if (event.isConfirmation()) {
                    this.select();
                    CutsceneKeyframeEasingsScreen.this.onClose();
                    return true;
                }
                return super.keyPressed(event);
            }

            public boolean mouseClicked(MouseButtonEvent p_446815_, boolean p_432750_) {
                this.select();
                return super.mouseClicked(p_446815_, p_432750_);
            }

            private void select() {
                CutsceneEasingsList.this.setSelected((AbstractSelectionList.Entry)this);
            }

            public Component getNarration() {
                return Component.literal((String)this.easing.name());
            }
        }
    }
}

