/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerSessionCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nc").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"session").then(Commands.literal((String)"clear").executes(PlayerSessionCommand::clearSession))).then(Commands.literal((String)"set").then(Commands.argument((String)"chapter_index", (ArgumentType)IntegerArgumentType.integer()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getChapterSuggestions()).then(Commands.argument((String)"scene_name", (ArgumentType)StringArgumentType.string()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getSceneSuggestionsByChapter()).executes(context -> PlayerSessionCommand.setSession((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"chapter_index"), StringArgumentType.getString((CommandContext)context, (String)"scene_name"))))))));
    }

    private static int setSession(CommandContext<CommandSourceStack> context, int chapterIndex, String sceneName) {
        if (!NarrativeCraftMod.getInstance().getChapterManager().chapterExists(chapterIndex)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("chapter.no_exists", chapterIndex));
            return 0;
        }
        Chapter chapter = NarrativeCraftMod.getInstance().getChapterManager().getChapterByIndex(chapterIndex);
        if (!chapter.sceneExists(sceneName)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("scene.no_exists", sceneName, chapterIndex));
            return 0;
        }
        Scene scene = chapter.getSceneByName(sceneName);
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).getPlayer());
        playerSession.setChapter(chapter);
        playerSession.setScene(scene);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("session.set", chapter.getIndex(), scene.getName()), false);
        return 1;
    }

    private static int clearSession(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)player);
        playerSession.reset();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("session.cleared", new Object[0]), false);
        return 1;
    }
}

