/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.managers.RecordingManager;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.recording.Recording;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.components.ChooseCharacterScreen;
import fr.loudo.narrativecraft.util.CommandUtil;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class RecordCommand {
    private static final RecordingManager recordingManager = NarrativeCraftMod.getInstance().getRecordingManager();
    public static final List<ServerPlayer> playerTryingOverride = new ArrayList<ServerPlayer>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nc").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"record").then(((LiteralArgumentBuilder)Commands.literal((String)"start").then(Commands.literal((String)"with").then(Commands.argument((String)"subscenes", (ArgumentType)StringArgumentType.greedyString()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getSubscenesOfScenesSuggestions()).executes(commandContext -> {
            String subscenes = StringArgumentType.getString((CommandContext)commandContext, (String)"subscenes");
            return RecordCommand.startRecordingWithSubscenes((CommandContext<CommandSourceStack>)commandContext, subscenes);
        })))).executes(RecordCommand::startRecording))).then(Commands.literal((String)"stop").executes(RecordCommand::stopRecording))).then(Commands.literal((String)"save").then(Commands.argument((String)"animation_name", (ArgumentType)StringArgumentType.string()).executes(context -> RecordCommand.saveRecording((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"animation_name")))))));
    }

    private static int startRecording(CommandContext<CommandSourceStack> context) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (recordingManager.isRecording(player)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("record.start.already_recording", new Object[0]));
            return 0;
        }
        Recording recording = recordingManager.getRecording((Entity)player);
        if (recording == null) {
            recording = new Recording((LivingEntity)((CommandSourceStack)context.getSource()).getPlayer(), playerSession);
        }
        recording.start();
        recordingManager.addRecording(recording);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("record.start.success", new Object[0]), false);
        return 1;
    }

    private static int startRecordingWithSubscenes(CommandContext<CommandSourceStack> context, String subscenes) {
        String[] subsceneNameList;
        PlayerSession playerSession = CommandUtil.getSession(context, ((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (recordingManager.isRecording(player)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("record.start.already_recording", new Object[0]));
            return 0;
        }
        ArrayList<Subscene> subsceneToPlay = new ArrayList<Subscene>();
        subscenes = subscenes.replaceAll("\"", "");
        for (String subsceneName : subsceneNameList = subscenes.split(",")) {
            Subscene subscene = playerSession.getScene().getSubsceneByName(subsceneName);
            if (subscene != null) {
                subsceneToPlay.add(subscene);
                continue;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("subscene.no_exists", subsceneName));
        }
        if (subsceneNameList.length == subsceneToPlay.size()) {
            Recording recording = recordingManager.getRecording((Entity)player);
            if (recording == null) {
                recording = new Recording((LivingEntity)((CommandSourceStack)context.getSource()).getPlayer(), playerSession, subsceneToPlay);
            }
            recording.start();
            recordingManager.addRecording(recording);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("record.start.with_subscenes", Arrays.toString(subsceneNameList)), true);
        }
        return 1;
    }

    private static int stopRecording(CommandContext<CommandSourceStack> context) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (!recordingManager.isRecording(player)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("record.stop.no_recording", new Object[0]));
            return 0;
        }
        Recording recording = recordingManager.getRecording((Entity)player);
        recording.stop();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("record.stop.success", new Object[0]), false);
        return 1;
    }

    private static int saveRecording(CommandContext<CommandSourceStack> context, String newAnimationName) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        Recording recording = recordingManager.getRecording((Entity)((CommandSourceStack)context.getSource()).getPlayer());
        if (recording == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("record.save.recorded_nothing", new Object[0]));
            return 0;
        }
        if (recording.isRecording()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("record.save.stop_record_before_save", new Object[0]));
            return 0;
        }
        recording.stop();
        Animation animation = playerSession.getScene().getAnimationByName(newAnimationName);
        if (animation != null) {
            if (!playerTryingOverride.contains(player)) {
                playerTryingOverride.add(((CommandSourceStack)context.getSource()).getPlayer());
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("record.save.overwrite", newAnimationName, playerSession.getScene().getName(), playerSession.getChapter().getIndex()));
                return 0;
            }
            playerTryingOverride.remove(player);
        } else {
            animation = new Animation(newAnimationName, playerSession.getScene());
            playerTryingOverride.remove(player);
        }
        Animation finalAnimation = animation;
        ChooseCharacterScreen screen = new ChooseCharacterScreen(null, Translation.message("screen.story_manager.link_animation_character", new Object[0]).getString(), null, playerSession.getScene(), characterStory -> {
            if (characterStory == null) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("animation.must_link_character", new Object[0]));
                return;
            }
            try {
                finalAnimation.setCharacter((CharacterStory)characterStory);
                recording.save(finalAnimation);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("record.save.success", finalAnimation.getName(), playerSession.getScene().getName(), playerSession.getChapter().getIndex()), true);
                recordingManager.removeRecording(recording);
            }
            catch (IOException e) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("record.save.fail", finalAnimation.getName(), playerSession.getChapter().getIndex(), playerSession.getScene().getName()));
            }
        });
        Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen((Screen)screen));
        return 1;
    }
}

