/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.character;

import com.google.common.io.Files;
import com.mojang.blaze3d.platform.NativeImage;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class CharacterSkinController {
    private final CharacterRuntime characterRuntime;
    private final List<String> cachedSkins;
    private String skinName;
    private List<File> skins;
    private File currentSkin;

    public CharacterSkinController(CharacterRuntime characterRuntime, String skinName) {
        this.characterRuntime = characterRuntime;
        this.skinName = skinName;
        if (characterRuntime.getCharacterStory() != null) {
            this.skins = NarrativeCraftFile.getSkinFiles(characterRuntime.getCharacterStory(), null);
        }
        this.cachedSkins = new ArrayList<String>();
    }

    public void cacheSkins() {
        if (this.characterRuntime.getCharacterStory() == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        this.unCacheSkins();
        this.skins = NarrativeCraftFile.getSkinFiles(this.characterRuntime.getCharacterStory(), null);
        for (File skin : NarrativeCraftFile.getSkinFiles(this.characterRuntime.getCharacterStory(), null)) {
            String path = "character/" + Util.snakeCase(this.characterRuntime.getCharacterStory().getName()) + "/" + Util.snakeCase(skin.getName());
            minecraft.execute(() -> {
                try {
                    byte[] array = Files.toByteArray((File)skin);
                    NativeImage nativeImage = NativeImage.read((byte[])array);
                    DynamicTexture texture = new DynamicTexture(() -> "narrativecraft_" + this.characterRuntime.getCharacterStory().getName() + "_" + Util.snakeCase(skin.getName()) + "_skin_texture", nativeImage);
                    minecraft.getTextureManager().register(ResourceLocation.fromNamespaceAndPath((String)"narrativecraft", (String)path), (AbstractTexture)texture);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            this.cachedSkins.add(path);
        }
        this.currentSkin = this.skinName == null || this.skinName.isEmpty() ? this.getMainSkinFile() : this.getSkinFile(this.skinName);
    }

    public void unCacheSkins() {
        Minecraft minecraft = Minecraft.getInstance();
        for (String path : this.cachedSkins) {
            minecraft.execute(() -> minecraft.getTextureManager().release(ResourceLocation.fromNamespaceAndPath((String)"narrativecraft", (String)path)));
        }
        this.cachedSkins.clear();
    }

    public File getMainSkinFile() {
        for (File skin : this.skins) {
            if (!skin.getName().equals("main.png")) continue;
            return skin;
        }
        return null;
    }

    public File getSkinFile(String name) {
        for (File skin : this.skins) {
            if (!skin.getName().equals(name)) continue;
            return skin;
        }
        return null;
    }

    public List<File> getSkins() {
        return this.skins;
    }

    public File getCurrentSkin() {
        return this.currentSkin;
    }

    public List<String> getCachedSkins() {
        return this.cachedSkins;
    }

    public void setCurrentSkin(File skinFile) {
        this.currentSkin = skinFile;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }
}

