/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.session;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.gui.StorySaveIconGui;
import fr.loudo.narrativecraft.managers.PlaybackManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.inkTag.InkTagHandler;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerSession {
    private final ServerPlayer player;
    private final PlaybackManager playbackManager = new PlaybackManager();
    private final List<InkAction> inkActions = new ArrayList<InkAction>();
    private final List<CharacterRuntime> characterRuntimes = new ArrayList<CharacterRuntime>();
    private final InkTagHandler inkTagHandler;
    private final StorySaveIconGui storySaveIconGui = new StorySaveIconGui(0.2, 0.9, 0.2);
    private AbstractController controller;
    private DialogRenderer dialogRenderer;
    private KeyframeLocation currentCamera;
    private StoryHandler storyHandler;
    private Chapter chapter;
    private Scene scene;
    private boolean showDebugHud;

    public PlayerSession(ServerPlayer player) {
        this.player = player;
        this.inkTagHandler = new InkTagHandler(this);
    }

    public PlayerSession(ServerPlayer player, Chapter chapter, Scene scene) {
        this.player = player;
        this.chapter = chapter;
        this.scene = scene;
        this.inkTagHandler = new InkTagHandler(this);
    }

    public void addInkAction(InkAction inkAction) {
        if (this.inkActions.contains(inkAction)) {
            return;
        }
        this.inkActions.add(inkAction);
    }

    public void removeInkAction(InkAction inkAction) {
        this.inkActions.remove(inkAction);
    }

    public boolean isSamePlayer(Player player) {
        if (player == null) {
            return false;
        }
        return this.player.getUUID().equals(player.getUUID());
    }

    public boolean isSessionSet() {
        return this.chapter != null && this.scene != null;
    }

    public void reset() {
        this.chapter = null;
        this.scene = null;
    }

    public Location getPlayerPosition() {
        return new Location(this.player.getX(), this.player.getY(), this.player.getZ(), this.player.getXRot(), this.player.getYRot(), this.player.onGround());
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public PlaybackManager getPlaybackManager() {
        return this.playbackManager;
    }

    public List<InkAction> getInkActions() {
        return this.inkActions;
    }

    public List<InkAction> getClientSideInkActions() {
        try {
            return this.inkActions.stream().filter(inkAction -> inkAction.getSide() != null && inkAction.getSide() == InkAction.Side.CLIENT).toList();
        }
        catch (Exception e) {
            return new ArrayList<InkAction>();
        }
    }

    public List<InkAction> getServerSideInkActions() {
        try {
            return this.inkActions.stream().filter(inkAction -> inkAction.getSide() != null && inkAction.getSide() == InkAction.Side.SERVER).toList();
        }
        catch (Exception e) {
            return new ArrayList<InkAction>();
        }
    }

    public InkTagHandler getInkTagHandler() {
        return this.inkTagHandler;
    }

    public CharacterRuntime getCharacterRuntimeByCharacter(CharacterStory characterStory) {
        this.clearKilledCharacters();
        for (CharacterRuntime characterRuntime : this.characterRuntimes) {
            if (characterRuntime.getEntity() == null || !characterRuntime.getEntity().isAlive() || !characterRuntime.getCharacterStory().getName().equalsIgnoreCase(characterStory.getName())) continue;
            return characterRuntime;
        }
        return null;
    }

    public void clearKilledCharacters() {
        this.characterRuntimes.removeIf(characterRuntime -> characterRuntime.getEntity() == null || !characterRuntime.getEntity().isAlive());
    }

    public List<CharacterRuntime> getCharacterRuntimes() {
        return this.characterRuntimes;
    }

    public DialogRenderer getDialogRenderer() {
        return this.dialogRenderer;
    }

    public void setDialogRenderer(DialogRenderer dialogRenderer) {
        this.dialogRenderer = dialogRenderer;
    }

    public Chapter getChapter() {
        return this.chapter;
    }

    public void setChapter(Chapter chapter) {
        this.chapter = chapter;
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public AbstractController getController() {
        return this.controller;
    }

    public void setController(AbstractController controller) {
        this.controller = controller;
    }

    public KeyframeLocation getCurrentCamera() {
        return this.currentCamera;
    }

    public StoryHandler getStoryHandler() {
        return this.storyHandler;
    }

    public void setStoryHandler(StoryHandler storyHandler) {
        this.storyHandler = storyHandler;
    }

    public void setCurrentCamera(KeyframeLocation currentCamera) {
        this.currentCamera = currentCamera;
    }

    public StorySaveIconGui getStorySaveIconGui() {
        return this.storySaveIconGui;
    }

    public boolean isShowDebugHud() {
        return this.showDebugHud;
    }

    public void setShowDebugHud(boolean showDebugHud) {
        this.showDebugHud = showDebugHud;
    }
}

