/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story;

import com.bladecoder.ink.runtime.Story;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.hud.StoryDebugHud;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogEntityBobbing;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer2D;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import fr.loudo.narrativecraft.narrative.inkTag.InkTagHandlerException;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StorySave;
import fr.loudo.narrativecraft.options.NarrativeClientOption;
import fr.loudo.narrativecraft.options.NarrativeWorldOption;
import fr.loudo.narrativecraft.screens.components.CrashScreen;
import fr.loudo.narrativecraft.screens.credits.CreditScreen;
import fr.loudo.narrativecraft.screens.story.StoryChoicesScreen;
import fr.loudo.narrativecraft.util.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class StoryHandler {
    private final NarrativeWorldOption worldOption = NarrativeCraftMod.getInstance().getNarrativeWorldOption();
    private final NarrativeClientOption clientOption = NarrativeCraftMod.getInstance().getNarrativeClientOptions();
    private final Minecraft minecraft = Minecraft.getInstance();
    public static final String DIALOG_REGEX = "^(\\w+)\\s*:\\s*(.+?)\\s*$";
    private final PlayerSession playerSession;
    private final StoryDebugHud storyDebugHud;
    private DialogData dialogData = new DialogData(DialogData.globalDialogData);
    private Story story;
    private String dialogText;
    private boolean loadScene;
    private boolean debugMode;
    private boolean firstLoad;
    private boolean hasError;

    public StoryHandler(PlayerSession playerSession) {
        this.playerSession = playerSession;
        Chapter firstChapter = NarrativeCraftMod.getInstance().getChapterManager().getChapterByIndex(1);
        playerSession.setChapter(firstChapter);
        playerSession.setScene(firstChapter.getSortedSceneList().getFirst());
        this.storyDebugHud = new StoryDebugHud(playerSession);
    }

    public StoryHandler(Chapter chapter, PlayerSession playerSession) {
        this.playerSession = playerSession;
        playerSession.setChapter(chapter);
        playerSession.setScene(chapter.getSortedSceneList().getFirst());
        this.storyDebugHud = new StoryDebugHud(playerSession);
    }

    public StoryHandler(Chapter chapter, Scene scene, PlayerSession playerSession) {
        this.playerSession = playerSession;
        playerSession.setChapter(chapter);
        playerSession.setScene(scene);
        this.loadScene = true;
        this.storyDebugHud = new StoryDebugHud(playerSession);
    }

    public boolean isRunning() {
        return this.story != null;
    }

    public boolean isFinished() {
        return !this.story.canContinue() && this.story.getCurrentChoices().isEmpty() && !this.story.hasError() && !this.hasError;
    }

    public void start() {
        this.playerSession.setStoryHandler(this);
        this.firstLoad = true;
        try {
            this.story = new Story(NarrativeCraftFile.storyContent());
            this.story.onError = (s, errorType) -> {
                NarrativeCraftMod.server.execute(this::stop);
                this.showCrash(new Exception(String.valueOf(errorType) + " " + s));
                this.hasError = true;
            };
            if (NarrativeCraftFile.saveExists() && !this.debugMode) {
                this.loadSave();
                if (!this.loadScene) {
                    return;
                }
            }
            if (this.loadScene) {
                this.loadScene(this.playerSession.getScene());
            }
            this.next();
        }
        catch (Exception e) {
            this.stop();
            this.showCrash(e);
        }
    }

    public void stop() {
        this.playerSession.getInkTagHandler().stopAll();
        for (InkAction inkAction : this.playerSession.getInkActions()) {
            inkAction.stop();
        }
        this.playerSession.getInkActions().clear();
        for (Playback playback : this.playerSession.getPlaybackManager().getPlaybacks()) {
            playback.stop(true);
        }
        for (CharacterRuntime characterRuntime : this.playerSession.getCharacterRuntimes()) {
            if (characterRuntime.getEntity() == null || !characterRuntime.getEntity().isAlive()) continue;
            characterRuntime.getEntity().remove(Entity.RemovalReason.KILLED);
        }
        AbstractController controller = this.playerSession.getController();
        if (controller != null) {
            controller.stopSession(false);
        }
        this.playerSession.setCurrentCamera(null);
        this.playerSession.getCharacterRuntimes().clear();
        this.playerSession.setDialogRenderer(null);
        this.playerSession.setStoryHandler(null);
        this.playerSession.getInkTagHandler().getTagsToExecute().clear();
    }

    public void stopAndFinishScreen() {
        this.stop();
        if (this.worldOption.showCreditsScreen && !this.debugMode) {
            CreditScreen creditScreen = new CreditScreen(this.playerSession, false, !this.worldOption.finishedStory);
            this.minecraft.execute(() -> this.minecraft.setScreen((Screen)creditScreen));
            this.worldOption.finishedStory = true;
            NarrativeCraftFile.updateWorldOptions(this.worldOption);
        }
    }

    public boolean characterInStory(CharacterStory characterStory) {
        for (CharacterRuntime characterRuntime : this.playerSession.getCharacterRuntimes()) {
            if (!characterRuntime.getCharacterStory().getName().equals(characterStory.getName())) continue;
            return true;
        }
        return false;
    }

    public CharacterRuntime getCharacterRuntimeFromCharacter(CharacterStory characterStory) {
        for (CharacterRuntime characterRuntime : this.playerSession.getCharacterRuntimes()) {
            if (!characterRuntime.getCharacterStory().getName().equals(characterStory.getName())) continue;
            return characterRuntime;
        }
        return null;
    }

    public void killCharacter(CharacterStory characterStory) {
        CharacterRuntime toRemove = null;
        for (CharacterRuntime characterRuntime : this.playerSession.getCharacterRuntimes()) {
            if (!characterRuntime.getCharacterStory().getName().equals(characterStory.getName()) || characterRuntime.getEntity() == null) continue;
            characterRuntime.getEntity().remove(Entity.RemovalReason.KILLED);
            toRemove = characterRuntime;
        }
        this.playerSession.getCharacterRuntimes().remove(toRemove);
    }

    public void chooseChoiceAndNext(int choiceIndex) {
        try {
            this.story.chooseChoiceIndex(choiceIndex);
            this.playerSession.setDialogRenderer(null);
            this.next();
            if (this.dialogText.isEmpty() && !this.isFinished()) {
                throw new Exception("Empty dialog after a choice cannot be rendered!");
            }
        }
        catch (Exception e) {
            this.stop();
            NarrativeCraftMod.LOGGER.error("Can't choose the choice: ", (Throwable)e);
            Util.sendCrashMessage((Player)this.minecraft.player, e);
        }
    }

    public void next() {
        try {
            if (this.story == null) {
                throw new Exception("Story is not initialized!");
            }
            if (this.isFinished()) {
                this.stopAndFinishScreen();
                return;
            }
            DialogRenderer dialogRenderer = this.playerSession.getDialogRenderer();
            this.dialogText = this.story.Continue().trim();
            if (this.story.hasError() || this.hasError) {
                return;
            }
            if (this.firstLoad) {
                this.save(false);
                this.firstLoad = false;
            }
            this.playerSession.getInkTagHandler().getTagsToExecute().addAll(this.story.getCurrentTags());
            if (!this.story.getCurrentChoices().isEmpty()) {
                this.handleChoices();
                return;
            }
            if (dialogRenderer == null || this.sameCharacterTalking(this.dialogText)) {
                this.playerSession.getInkTagHandler().execute();
            } else {
                dialogRenderer.stop();
            }
            this.playerSession.clearKilledCharacters();
        }
        catch (Exception e) {
            this.stop();
            this.showCrash(e);
        }
    }

    public void showCurrentDialog() {
        try {
            this.showDialog(this.dialogText);
        }
        catch (Exception e) {
            this.stop();
            this.showCrash(e);
        }
    }

    public Matcher getDialogMatcher(String dialog) {
        Pattern pattern = Pattern.compile(DIALOG_REGEX);
        return pattern.matcher(dialog);
    }

    private void loadSave() throws Exception {
        StorySave save = NarrativeCraftFile.saveContent();
        if (save == null) {
            throw new Exception("Chapter or scene cannot be found in save file");
        }
        this.story.getState().loadJson(save.getSaveData());
        if (this.loadScene) {
            return;
        }
        this.playerSession.setChapter(save.getChapter());
        this.playerSession.setScene(save.getScene());
        this.removeForbiddenTagLoadSave();
        this.story.getCurrentTags().addAll(save.getTagsRunning());
        this.playerSession.getInkTagHandler().getTagsToExecute().addAll(this.story.getCurrentTags());
        for (CharacterStoryData characterStoryData : save.getCharacterStoryDataList()) {
            characterStoryData.spawn((Level)this.playerSession.getPlayer().level(), Environment.PRODUCTION);
            this.playerSession.getCharacterRuntimes().add(characterStoryData.getCharacterRuntime());
        }
        this.dialogData = save.getDialogData();
        this.dialogText = this.story.getCurrentText();
        this.playerSession.getInkTagHandler().execute();
        if (!this.story.getCurrentChoices().isEmpty()) {
            this.handleChoices();
        }
    }

    private void loadScene(Scene scene) throws Exception {
        this.story.choosePathString(scene.knotName());
    }

    private void removeForbiddenTagLoadSave() throws Exception {
        this.story.getCurrentTags().remove("save");
        this.story.getCurrentTags().remove("on enter");
    }

    private void handleChoices() {
        DialogRenderer dialogRenderer = this.playerSession.getDialogRenderer();
        if (dialogRenderer != null) {
            dialogRenderer.stop();
            dialogRenderer.setRunDialogStopped(this::showChoices);
        } else {
            this.showChoices();
        }
    }

    private void showChoices() {
        this.playerSession.setDialogRenderer(null);
        this.playerSession.getInkTagHandler().execute();
        StoryChoicesScreen choicesScreen = new StoryChoicesScreen(this.playerSession, true);
        this.minecraft.execute(() -> this.minecraft.setScreen((Screen)choicesScreen));
    }

    private void showCrash(Exception exception) {
        if (this.debugMode) {
            NarrativeCraftMod.LOGGER.error("Error occurred on the story: ", (Throwable)exception);
            Util.sendCrashMessage((Player)this.playerSession.getPlayer(), exception);
        } else {
            CrashScreen screen = new CrashScreen(this.playerSession, exception.getMessage());
            this.minecraft.execute(() -> this.minecraft.setScreen((Screen)screen));
        }
    }

    public void save(boolean showLogo) {
        try {
            if (!this.debugMode) {
                StorySave save = new StorySave(this.playerSession);
                NarrativeCraftFile.writeSave(save);
            }
            if (showLogo) {
                this.playerSession.getStorySaveIconGui().showSave(this.debugMode);
            }
        }
        catch (Exception e) {
            this.stop();
            this.showCrash(e);
        }
    }

    public boolean isChangingScene() {
        String currentKnot = this.story.getState().getCurrentKnot();
        return currentKnot != null && !currentKnot.equalsIgnoreCase(this.playerSession.getScene().knotName());
    }

    private void showDialog(String dialog) throws Exception {
        if (dialog == null || ((String)dialog).isEmpty()) {
            return;
        }
        Matcher matcher = this.getDialogMatcher((String)dialog);
        CharacterStory characterStory = null;
        if (matcher.matches()) {
            String characterName = matcher.group(1).trim();
            characterStory = NarrativeCraftMod.getInstance().getCharacterManager().getCharacterByName(characterName);
            if (characterStory == null) {
                characterStory = this.playerSession.getScene().getNpcByName(characterName);
            }
            if (characterStory == null) {
                throw new Exception("Character " + characterName + " was not found.");
            }
            if (!this.characterInStory(characterStory)) {
                throw new Exception("Character " + characterName + " is not in the story, can't render the dialog.");
            }
            dialog = matcher.group(2).trim() + "\n";
        }
        DialogRenderer newDialogRenderer = this.getDialogRenderer((String)dialog, characterStory);
        DialogRenderer dialogRenderer = this.playerSession.getDialogRenderer();
        if (dialogRenderer == null || newDialogRenderer.getClass() != dialogRenderer.getClass()) {
            this.playerSession.setDialogRenderer(newDialogRenderer);
            newDialogRenderer.setRunDialogStopped(() -> {
                this.playerSession.setDialogRenderer(null);
                try {
                    if (this.playerSession.getInkTagHandler().getTagsToExecute().isEmpty()) {
                        this.showCurrentDialog();
                    } else {
                        this.playerSession.getInkTagHandler().execute();
                    }
                }
                catch (Exception e) {
                    this.stop();
                    if (!this.debugMode && e instanceof InkTagHandlerException) {
                        CrashScreen screen = new CrashScreen(this.playerSession, e.getMessage());
                        this.minecraft.execute(() -> this.minecraft.setScreen((Screen)screen));
                    }
                    Util.sendCrashMessage((Player)this.playerSession.getPlayer(), e);
                }
            });
            newDialogRenderer.setRunDialogAutoSkipped(this::next);
            newDialogRenderer.start();
        } else {
            dialogRenderer.setText((String)dialog);
            dialogRenderer.update();
        }
    }

    private boolean sameCharacterTalking(String dialog) {
        DialogRenderer dialogRenderer = this.playerSession.getDialogRenderer();
        Matcher matcher = this.getDialogMatcher(dialog);
        if (dialog.isEmpty()) {
            return true;
        }
        if (dialogRenderer instanceof DialogRenderer2D && !matcher.matches()) {
            return true;
        }
        if (!(dialogRenderer instanceof DialogRenderer3D)) {
            return false;
        }
        String characterName = "";
        if (matcher.matches()) {
            characterName = matcher.group(1).trim();
        }
        return ((DialogRenderer3D)dialogRenderer).getCharacterRuntime().getCharacterStory().getName().equalsIgnoreCase(characterName);
    }

    private DialogRenderer getDialogRenderer(String dialog, CharacterStory characterStory) {
        DialogRenderer dialogRenderer;
        if (characterStory != null) {
            CharacterRuntime characterRuntime = this.playerSession.getCharacterRuntimeByCharacter(characterStory);
            dialogRenderer = new DialogRenderer3D(dialog, characterStory.getName(), this.dialogData, characterRuntime);
            DialogRenderer3D dialogRenderer3D = (DialogRenderer3D)dialogRenderer;
            dialogRenderer3D.setDialogEntityBobbing(new DialogEntityBobbing(dialogRenderer3D, this.dialogData.getNoiseShakeSpeed(), this.dialogData.getNoiseShakeStrength()));
        } else {
            dialogRenderer = new DialogRenderer2D(dialog, 350, 400, 90, 30, this.dialogData);
        }
        dialogRenderer.autoSkipAt(this.dialogData.getAutoSkipSeconds());
        dialogRenderer.setNoSkip(this.dialogData.isNoSkip());
        if (this.clientOption.autoSkip) {
            String[] words = dialog.trim().split("\\s+");
            int wordCount = words.length;
            double readingSpeed = 3.0;
            int autoSkipTime = (int)Math.ceil((double)wordCount / readingSpeed);
            autoSkipTime = Math.max(autoSkipTime, 2);
            dialogRenderer.autoSkipAt(autoSkipTime);
        }
        return dialogRenderer;
    }

    public DialogData getDialogData() {
        return this.dialogData;
    }

    public void setDialogData(DialogData dialogData) {
        this.dialogData = dialogData;
    }

    public Story getStory() {
        return this.story;
    }

    public String getDialogText() {
        return this.dialogText;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public StoryDebugHud getStoryDebugHud() {
        return this.storyDebugHud;
    }
}

