/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.MathHelper;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;

public class KeyframeOptionScreen<T extends Keyframe, E extends AbstractKeyframeController<T>>
extends Screen {
    protected final int INITIAL_POS_X = 20;
    protected final int INITIAL_POS_Y = 15;
    protected final int EDIT_BOX_WIDTH = 60;
    protected final int EDIT_BOX_HEIGHT = 15;
    protected final int BUTTON_HEIGHT = 20;
    protected final List<EditBox> coordinatesBoxList = new ArrayList<EditBox>();
    protected final List<Button> littleButtons = new ArrayList<Button>();
    protected final ServerPlayer player;
    protected final PlayerSession playerSession;
    protected final T keyframe;
    protected final E keyframeController;
    protected Runnable reloadScreen;
    protected float upDownValue;
    protected float leftRightValue;
    protected float rotationValue;
    protected float fovValue;
    protected int currentY = 15;
    protected boolean hide;

    public KeyframeOptionScreen(T keyframe, E keyframeController, PlayerSession playerSession, boolean hide) {
        super((Component)Component.literal((String)"Keyframe Option"));
        this.keyframe = keyframe;
        this.player = playerSession.getPlayer();
        this.playerSession = playerSession;
        this.upDownValue = ((Keyframe)keyframe).getKeyframeLocation().getPitch();
        this.leftRightValue = ((Keyframe)keyframe).getKeyframeLocation().getYaw();
        this.rotationValue = ((Keyframe)keyframe).getKeyframeLocation().getRoll();
        this.fovValue = ((Keyframe)keyframe).getKeyframeLocation().getFov();
        this.hide = hide;
        this.keyframeController = keyframeController;
    }

    protected void init() {
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void renderBlurredBackground(GuiGraphics guiGraphics) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected EditBox addLabeledEditBox(Component text, String defaultValue) {
        StringWidget labelWidget = ScreenUtils.text(text, this.font, 20, this.currentY);
        EditBox editBox = new EditBox(this.font, 20 + labelWidget.getWidth() + 5, this.currentY - labelWidget.getHeight() / 2, 60, 15, (Component)Component.literal((String)(text.getString() + " Value")));
        editBox.setValue(defaultValue);
        editBox.setFilter(s -> s.matches("^\\d*(\\.\\d*)?$"));
        this.addRenderableWidget((GuiEventListener)labelWidget);
        this.addRenderableWidget((GuiEventListener)editBox);
        this.currentY += 20;
        return editBox;
    }

    protected void initButtons() {
    }

    protected void initPositionLabelBox() {
        String[] labels;
        int currentX = 20;
        int editWidth = 50;
        int i = 0;
        KeyframeLocation position = ((Keyframe)this.keyframe).getKeyframeLocation();
        Double[] coords = new Double[]{position.getX(), position.getY(), position.getZ()};
        for (String label : labels = new String[]{"X:", "Y:", "Z:"}) {
            StringWidget stringWidget = ScreenUtils.text((Component)Component.literal((String)label), this.font, currentX, this.currentY);
            EditBox box = new EditBox(this.font, currentX + stringWidget.getWidth() + 5, this.currentY - stringWidget.getHeight() / 2, editWidth, 15, (Component)Component.literal((String)(String.valueOf(stringWidget) + " Value")));
            box.setFilter(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
            box.setValue(String.format(Locale.US, "%.2f", coords[i]));
            this.addRenderableWidget((GuiEventListener)stringWidget);
            this.addRenderableWidget((GuiEventListener)box);
            this.coordinatesBoxList.add(box);
            currentX += stringWidget.getWidth() + editWidth + 10;
            ++i;
        }
        this.currentY += 20;
    }

    protected void initTextSelectedKeyframe() {
    }

    protected void initLittleButtons() {
        T previousKeyframe;
        int currentX = this.width - 20;
        int gap = 5;
        int width = 20;
        if (this.hide) {
            Button eyeClosed = Button.builder((Component)ImageFontConstants.EYE_CLOSED, button -> this.minecraft.setScreen(((AbstractKeyframeController)this.keyframeController).keyframeOptionScreen((Keyframe)this.keyframe, false))).bounds(currentX - width / 2, 10, width, 20).build();
            this.littleButtons.add(eyeClosed);
            this.addRenderableWidget((GuiEventListener)eyeClosed);
            return;
        }
        Button closeButton = Button.builder((Component)Component.literal((String)"\u2716"), button -> {
            ((AbstractKeyframeController)this.keyframeController).setCamera(null);
            this.minecraft.setScreen(null);
        }).bounds(currentX - width / 2, 10, width, 20).build();
        this.littleButtons.add(closeButton);
        T nextKeyframe = this.keyframeController.getNextKeyframe(this.keyframe);
        if (((Keyframe)nextKeyframe).getId() != ((Keyframe)this.keyframe).getId()) {
            Button rightKeyframeButton = Button.builder((Component)Component.literal((String)"\u25b6"), button -> NarrativeCraftMod.server.execute(() -> ((AbstractKeyframeController)this.keyframeController).setCamera((Keyframe)nextKeyframe))).bounds((currentX -= 20 + gap) - width / 2, 10, width, 20).build();
            this.addRenderableWidget((GuiEventListener)rightKeyframeButton);
        }
        if (((Keyframe)(previousKeyframe = this.keyframeController.getPreviousKeyframe(this.keyframe))).getId() != ((Keyframe)this.keyframe).getId()) {
            Button leftKeyframeButton = Button.builder((Component)Component.literal((String)"\u25c0"), button -> NarrativeCraftMod.server.execute(() -> ((AbstractKeyframeController)this.keyframeController).setCamera((Keyframe)previousKeyframe))).bounds((currentX -= 20 + gap) - width / 2, 10, width, 20).build();
            this.littleButtons.add(leftKeyframeButton);
            this.addRenderableWidget((GuiEventListener)leftKeyframeButton);
        }
        this.addRenderableWidget((GuiEventListener)closeButton);
        Button eyeOpen = Button.builder((Component)ImageFontConstants.EYE_OPEN, button -> this.minecraft.setScreen(((AbstractKeyframeController)this.keyframeController).keyframeOptionScreen((Keyframe)this.keyframe, true))).bounds((currentX -= 20 + gap) - width / 2, 10, width, 20).build();
        this.littleButtons.add(eyeOpen);
        this.addRenderableWidget((GuiEventListener)eyeOpen);
    }

    protected void initSliders() {
        int initialY = this.height - 50;
        int gap = 5;
        int numSliders = 4;
        int sliderWidth = (this.width - gap * (numSliders + 1)) / numSliders;
        int currentX = gap;
        final Function<Float, String> formatFloat = val -> String.format(Locale.US, "%.2f", val);
        float defaultXRot = ((Keyframe)this.keyframe).getKeyframeLocation().getPitch();
        float defaultValXRot = defaultXRot + 90.0f;
        AbstractSliderButton upDownSlider = new AbstractSliderButton(currentX, initialY, sliderWidth, 20, (Component)Translation.message("screen.keyframe_option.up_down", formatFloat.apply(Float.valueOf(defaultValXRot))), defaultValXRot / 180.0f){

            protected void updateMessage() {
                this.setMessage((Component)Translation.message("screen.keyframe_option.up_down", formatFloat.apply(Float.valueOf(this.getValue() + 90.0f))));
            }

            protected void applyValue() {
                KeyframeOptionScreen.this.upDownValue = this.getValue();
                KeyframeOptionScreen.this.updateValues();
            }

            public float getValue() {
                return (float)(this.value * 180.0 - 90.0);
            }
        };
        EditBox upDownBox = new EditBox(this.font, currentX, initialY + 20 + 5, 60, 15, (Component)Component.literal((String)"Up Down Value"));
        upDownBox.setValue(formatFloat.apply(Float.valueOf(defaultValXRot)));
        upDownBox.setFilter(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        Button upDownButton = Button.builder((Component)Component.literal((String)"\u2714"), btn -> {
            try {
                this.upDownValue = Float.parseFloat(upDownBox.getValue()) - 90.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).bounds(currentX + 60 + 5, upDownBox.getY(), 20, 15).build();
        this.addRenderableWidget((GuiEventListener)upDownSlider);
        this.addRenderableWidget((GuiEventListener)upDownBox);
        this.addRenderableWidget((GuiEventListener)upDownButton);
        float defaultYRot = MathHelper.wrapDegrees360(((Keyframe)this.keyframe).getKeyframeLocation().getYaw());
        AbstractSliderButton leftRightSlider = new AbstractSliderButton(currentX += sliderWidth + gap, initialY, sliderWidth, 20, (Component)Translation.message("screen.keyframe_option.left_right", formatFloat.apply(Float.valueOf(defaultYRot))), defaultYRot / 360.0f){

            protected void updateMessage() {
                float value = MathHelper.wrapDegrees360(((Keyframe)KeyframeOptionScreen.this.keyframe).getKeyframeLocation().getYaw());
                if (value == 0.0f && this.value == 1.0) {
                    value = 360.0f;
                }
                this.setMessage((Component)Translation.message("screen.keyframe_option.left_right", formatFloat.apply(Float.valueOf(value))));
            }

            protected void applyValue() {
                KeyframeOptionScreen.this.leftRightValue = this.getValue();
                KeyframeOptionScreen.this.updateValues();
            }

            public float getValue() {
                return Mth.wrapDegrees((float)((float)(this.value * 360.0)));
            }
        };
        EditBox leftRightBox = new EditBox(this.font, currentX, initialY + 20 + 5, 60, 15, (Component)Component.literal((String)"Left Right Value"));
        leftRightBox.setValue(formatFloat.apply(Float.valueOf(defaultYRot)));
        leftRightBox.setFilter(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        Button leftRightButton = Button.builder((Component)Component.literal((String)"\u2714"), btn -> {
            try {
                this.leftRightValue = Float.parseFloat(leftRightBox.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).bounds(currentX + 60 + 5, leftRightBox.getY(), 20, 15).build();
        this.addRenderableWidget((GuiEventListener)leftRightSlider);
        this.addRenderableWidget((GuiEventListener)leftRightBox);
        this.addRenderableWidget((GuiEventListener)leftRightButton);
        float defaultZRot = Mth.wrapDegrees((float)((Keyframe)this.keyframe).getKeyframeLocation().getRoll());
        AbstractSliderButton rotationSlider = new AbstractSliderButton(currentX += sliderWidth + gap, initialY, sliderWidth, 20, (Component)Translation.message("screen.keyframe_option.rotation", formatFloat.apply(Float.valueOf(defaultZRot))), (((Keyframe)this.keyframe).getKeyframeLocation().getRoll() + 180.0f) % 360.0f / 360.0f){

            protected void updateMessage() {
                float angle = (float)(this.value * 360.0 - 180.0);
                this.setMessage((Component)Translation.message("screen.keyframe_option.rotation", formatFloat.apply(Float.valueOf(angle))));
            }

            protected void applyValue() {
                float angle = (float)(this.value * 360.0 - 180.0);
                KeyframeOptionScreen.this.rotationValue = (angle + 360.0f) % 360.0f;
                KeyframeOptionScreen.this.updateValues();
            }
        };
        EditBox rotationBox = new EditBox(this.font, currentX, initialY + 20 + 5, 60, 15, (Component)Component.literal((String)"Rotation Value"));
        rotationBox.setValue(formatFloat.apply(Float.valueOf(defaultZRot)));
        rotationBox.setFilter(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        Button rotationButton = Button.builder((Component)Component.literal((String)"\u2714"), btn -> {
            try {
                float angle = Float.parseFloat(rotationBox.getValue());
                this.rotationValue = (angle + 360.0f) % 360.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).bounds(currentX + 60 + 5, rotationBox.getY(), 20, 15).build();
        this.addRenderableWidget((GuiEventListener)rotationSlider);
        this.addRenderableWidget((GuiEventListener)rotationBox);
        this.addRenderableWidget((GuiEventListener)rotationButton);
        float defaultFov = ((Keyframe)this.keyframe).getKeyframeLocation().getFov();
        AbstractSliderButton fovSlider = new AbstractSliderButton(currentX += sliderWidth + gap, initialY, sliderWidth, 20, (Component)Translation.message("screen.keyframe_option.fov", formatFloat.apply(Float.valueOf(defaultFov))), defaultFov / 150.0f){

            protected void updateMessage() {
                this.setMessage((Component)Translation.message("screen.keyframe_option.fov", formatFloat.apply(Float.valueOf(this.getValue()))));
            }

            protected void applyValue() {
                KeyframeOptionScreen.this.fovValue = this.getValue();
                KeyframeOptionScreen.this.updateValues();
            }

            public float getValue() {
                return (float)(this.value * 150.0);
            }
        };
        EditBox fovBox = new EditBox(this.font, currentX, initialY + 20 + 5, 60, 15, (Component)Component.literal((String)"FOV Value"));
        fovBox.setValue(formatFloat.apply(Float.valueOf(defaultFov)));
        fovBox.setFilter(s -> s.matches("^\\d*$"));
        Button fovButton = Button.builder((Component)Component.literal((String)"\u2714"), btn -> {
            try {
                this.fovValue = Float.parseFloat(fovBox.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).bounds(currentX + 60 + 5, fovBox.getY(), 20, 15).build();
        this.addRenderableWidget((GuiEventListener)fovSlider);
        this.addRenderableWidget((GuiEventListener)fovBox);
        this.addRenderableWidget((GuiEventListener)fovButton);
    }

    protected void updateValues() {
    }

    public boolean isHide() {
        return this.hide;
    }
}

