/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.animations;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.screens.components.ChooseCharacterScreen;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.animations.EditScreenAnimationAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class AnimationsScreen
extends StoryElementScreen {
    private final Scene scene;

    public AnimationsScreen(Scene scene) {
        super((Component)Translation.message("screen.story_manager.animation_list", scene.getName()));
        this.scene = scene;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, p_345997_ -> this.onClose()).width(200).build());
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)new ScenesMenuScreen(this.scene));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.scene.getAnimations().stream().map(animation -> {
            Button button = Button.builder((Component)Component.literal((String)animation.getName()), button1 -> {}).build();
            button.active = false;
            return new StoryElementList.StoryEntryData(button, List.of(this.createSettingsButton((Animation)animation)), () -> this.minecraft.setScreen(new EditInfoScreen<Animation>(this, (Animation)animation, new EditScreenAnimationAdapter(this.scene))), () -> {
                this.minecraft.setScreen((Screen)new AnimationsScreen(this.scene));
                this.scene.removeAnimation((Animation)animation);
                NarrativeCraftFile.deleteAnimationFile(animation);
                this.minecraft.setScreen((Screen)new AnimationsScreen(this.scene));
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }

    private Button createSettingsButton(Animation animation) {
        return Button.builder((Component)ImageFontConstants.SETTINGS, button1 -> {
            ChooseCharacterScreen screen = new ChooseCharacterScreen((Screen)this, Translation.message("screen.story_manager.link_animation_character", new Object[0]).getString(), animation.getCharacter(), this.scene, characterStory -> {
                if (characterStory == null) {
                    ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("character.must_link_character", new Object[0]));
                    return;
                }
                animation.setCharacter((CharacterStory)characterStory);
            });
            this.minecraft.setScreen((Screen)screen);
        }).build();
    }

    @Override
    protected void openFolder() {
        Util.getPlatform().openPath(NarrativeCraftFile.getAnimationsFolder(this.scene).toPath());
    }
}

