/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.api.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class InkActionRegistry {
    private static final Map<String, Supplier<InkAction>> ACTIONS = new HashMap<String, Supplier<InkAction>>();

    public static void register(Supplier<InkAction> supplier) {
        ACTIONS.put(supplier.get().id, supplier);
    }

    public static InkAction get(String id) {
        Supplier<InkAction> supplier = ACTIONS.get(id);
        return supplier != null ? supplier.get() : null;
    }

    public static InkAction findByCommand(String command) {
        for (Supplier<InkAction> supplier : ACTIONS.values()) {
            InkAction inkAction = supplier.get();
            if (!inkAction.getMatcher().matches(command)) continue;
            return inkAction;
        }
        return null;
    }
}

