/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.gui;

import fr.loudo.narrativecraft.util.ImageFontConstants;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class StorySaveIconGui {
    private final class_310 minecraft = class_310.method_1551();
    private int currentTick;
    private int totalTickIn;
    private int totalTickStay;
    private int totalTickOut;
    private int totalTick;
    private State state = State.IN;
    private boolean saving;
    private boolean debugMode;

    public StorySaveIconGui(double in, double stay, double out) {
        this.totalTickIn = (int)(in * 20.0);
        this.totalTickStay = (int)(stay * 20.0);
        this.totalTickOut = (int)(out * 20.0);
        this.totalTick = this.totalTickIn;
    }

    public void tick() {
        if (!this.saving) {
            return;
        }
        if (this.currentTick < this.totalTick) {
            ++this.currentTick;
        }
        if (this.currentTick == this.totalTick) {
            this.currentTick = 0;
            switch (this.state) {
                case IN: {
                    this.totalTick = this.totalTickStay;
                    this.state = State.STAY;
                    break;
                }
                case STAY: {
                    this.totalTick = this.totalTickOut;
                    this.state = State.OUT;
                    break;
                }
                case OUT: {
                    this.saving = false;
                }
            }
        }
    }

    public void showSave(boolean debugMode) {
        this.debugMode = debugMode;
        this.currentTick = 0;
        this.saving = true;
        this.state = State.IN;
    }

    public void render(class_332 guiGraphics, float partialTick) {
        if (!this.saving) {
            return;
        }
        double t = class_3532.method_15350((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
        double opacity = 1.0;
        switch (this.state) {
            case IN: {
                opacity = class_3532.method_16436((double)t, (double)0.0, (double)1.0);
                break;
            }
            case OUT: {
                opacity = class_3532.method_16436((double)t, (double)1.0, (double)0.0);
            }
        }
        String logo = ImageFontConstants.SAVE.getString();
        int logoWidth = this.minecraft.field_1772.method_1727(logo);
        int width = guiGraphics.method_51421();
        int height = guiGraphics.method_51443();
        int x = width - logoWidth - 30;
        int y = height - 30;
        guiGraphics.method_51433(this.minecraft.field_1772, logo, x, y, class_5253.class_8045.method_48343((int)((int)(opacity * 255.0)), (int)0xFFFFFF), false);
        if (this.debugMode) {
            class_5250 message = class_2561.method_43470((String)"Fake save (debug)");
            class_327 class_3272 = this.minecraft.field_1772;
            int n = x - this.minecraft.field_1772.method_27525((class_5348)message) / 2 - 5;
            Objects.requireNonNull(this.minecraft.field_1772);
            guiGraphics.method_51439(class_3272, (class_2561)message, n, y - 9 - 10, class_5253.class_8045.method_48343((int)((int)(opacity * 255.0)), (int)0xFFFFFF), false);
        }
    }

    static enum State {
        IN,
        STAY,
        OUT;

    }
}

