/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.hud;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5253;

public class StoryDebugHud {
    private final class_310 minecraft = class_310.method_1551();
    private final PlayerSession playerSession;

    public StoryDebugHud(PlayerSession playerSession) {
        this.playerSession = playerSession;
    }

    public void render(class_332 guiGraphics, float partialTick) {
        if (this.playerSession.getStoryHandler() == null) {
            return;
        }
        ArrayList<InkAction> inkActions = new ArrayList<InkAction>(this.playerSession.getInkActions());
        int x = 5;
        int y = 5;
        int color = class_5253.class_8045.method_48344((int)255, (int)255, (int)255, (int)255);
        guiGraphics.method_25303(this.minecraft.field_1772, "Ink tag running:", x, y, color);
        Objects.requireNonNull(this.minecraft.field_1772);
        y += 9 + 5;
        for (InkAction inkAction2 : inkActions) {
            Object command = inkAction2.getCommand();
            if (((String)command).length() > 25) {
                command = ((String)command).substring(0, 25) + "...";
            }
            guiGraphics.method_25303(this.minecraft.field_1772, "\"" + (String)command + "\"", x, y, color);
            Objects.requireNonNull(this.minecraft.field_1772);
            y += 9 + 5;
        }
        y = 5;
        String headerTag = "Ink tag running:";
        String longestInkCommand = inkActions.stream().map(inkAction -> {
            Object command = inkAction.getCommand();
            if (((String)command).length() > 25) {
                command = ((String)command).substring(0, 25) + "...";
            }
            return "\"" + (String)command + "\"";
        }).max(Comparator.comparingInt(String::length)).orElse(headerTag);
        guiGraphics.method_25303(this.minecraft.field_1772, "Characters in the world:", x += this.minecraft.field_1772.method_1727(headerTag.length() > longestInkCommand.length() ? headerTag : longestInkCommand) + 10, y, color);
        Objects.requireNonNull(this.minecraft.field_1772);
        y += 9 + 5;
        List<CharacterRuntime> characterRuntimes = this.playerSession.getCharacterRuntimes();
        for (CharacterRuntime characterRuntime2 : characterRuntimes) {
            guiGraphics.method_25303(this.minecraft.field_1772, characterRuntime2.getCharacterStory().getName(), x, y, color);
            Objects.requireNonNull(this.minecraft.field_1772);
            y += 9 + 5;
        }
        String headerChara = "Characters in the world:";
        String longestCharaName = characterRuntimes.stream().map(characterRuntime -> characterRuntime.getCharacterStory().getName()).max(Comparator.comparingInt(String::length)).orElse(headerChara);
        guiGraphics.method_25303(this.minecraft.field_1772, "Session:", x += this.minecraft.field_1772.method_1727(headerChara.length() > longestCharaName.length() ? headerChara : longestCharaName) + 10, 5, color);
        String chapterText = "Chapter " + this.playerSession.getChapter().getIndex();
        class_327 class_3272 = this.minecraft.field_1772;
        Objects.requireNonNull(this.minecraft.field_1772);
        guiGraphics.method_25303(class_3272, chapterText, x, 9 + 10, color);
        String sceneName = this.playerSession.getScene().getName();
        class_327 class_3273 = this.minecraft.field_1772;
        Objects.requireNonNull(this.minecraft.field_1772);
        guiGraphics.method_25303(class_3273, sceneName, x, 9 + 23, color);
        String stitchName = this.playerSession.getStitch();
        if (stitchName != null) {
            class_327 class_3274 = this.minecraft.field_1772;
            Objects.requireNonNull(this.minecraft.field_1772);
            guiGraphics.method_25303(class_3274, stitchName, x, 9 + 35, color);
        }
    }
}

