/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.character;

import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_4050;
import net.minecraft.class_7923;

public class CharacterStoryData {
    private transient CharacterRuntime characterRuntime;
    private final Location location;
    private final List<ItemSlotData> itemSlotDataList = new ArrayList<ItemSlotData>();
    private String poseName = class_4050.field_18076.name();
    private byte entityByte;
    private byte livingEntityByte;
    private String skinName = "main.png";
    private transient String oldSkinName = "main.png";
    private boolean isTemplate;

    public CharacterStoryData(CharacterStory characterStory, Location location, boolean isTemplate, Scene scene) {
        this.characterRuntime = new CharacterRuntime(characterStory, this.skinName, null, scene);
        this.location = location;
        this.isTemplate = isTemplate;
    }

    public void spawn(class_1937 level, Environment environment) {
        if (this.isTemplate && environment == Environment.PRODUCTION && this.characterRuntime.getCharacterStory() == null) {
            return;
        }
        this.characterRuntime.getCharacterSkinController().setSkinName(this.skinName);
        this.characterRuntime.getCharacterSkinController().cacheSkins();
        this.characterRuntime.setEntity(Util.createEntityFromCharacter(this.characterRuntime.getCharacterStory(), level));
        this.characterRuntime.getEntity().method_5808(this.location.x(), this.location.y(), this.location.z(), this.location.yaw(), this.location.pitch());
        this.characterRuntime.getEntity().method_5847(this.location.yaw());
        this.characterRuntime.getEntity().method_24830(this.location.onGround());
        try {
            this.characterRuntime.getEntity().method_18380(class_4050.valueOf((String)this.poseName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.applyBytes(this.characterRuntime.getEntity());
        this.applyItems();
    }

    public void applyBytes(class_1309 entity) {
        entity.method_5841().method_12778(EntityAccessor.getDATA_SHARED_FLAGS_ID(), (Object)this.entityByte);
        entity.method_5841().method_12778(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS(), (Object)this.livingEntityByte);
    }

    public void applyItems() {
        for (ItemSlotData itemSlotData : this.itemSlotDataList) {
            try {
                this.characterRuntime.getEntity().method_5673(class_1304.valueOf((String)itemSlotData.equipmentSlot), itemSlotData.getItem());
            }
            catch (Exception exception) {}
        }
    }

    public void kill() {
        if (this.characterRuntime.getEntity() == null) {
            return;
        }
        this.characterRuntime.getEntity().method_5650(class_1297.class_5529.field_26998);
    }

    public void setItems(class_1309 entity) {
        this.itemSlotDataList.clear();
        for (class_1304 equipmentSlot : class_1304.values()) {
            class_1799 itemStack = entity.method_6118(equipmentSlot);
            if (!itemStack.method_7960()) {
                class_2487 componentsTag = itemStack.method_7969();
                String itemData = componentsTag == null ? "" : componentsTag.toString();
                this.itemSlotDataList.add(new ItemSlotData(class_7923.field_41178.method_10206((Object)itemStack.method_7909()), itemData, equipmentSlot.name()));
                continue;
            }
            this.itemSlotDataList.add(new ItemSlotData(class_7923.field_41178.method_10206((Object)class_1802.field_8162), "", equipmentSlot.name()));
        }
    }

    public byte getLivingEntityByte() {
        return this.livingEntityByte;
    }

    public void setLivingEntityByte(byte livingEntityByte) {
        this.livingEntityByte = livingEntityByte;
    }

    public byte getEntityByte() {
        return this.entityByte;
    }

    public void setEntityByte(byte entityByte) {
        this.entityByte = entityByte;
    }

    public Location getLocation() {
        return this.location;
    }

    public class_4050 getPose() {
        try {
            return class_4050.valueOf((String)this.poseName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void setPose(class_4050 pose) {
        this.poseName = pose.name();
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinName(String skinName) {
        this.oldSkinName = this.skinName;
        this.skinName = skinName;
    }

    public String getOldSkinName() {
        if (this.oldSkinName == null) {
            this.oldSkinName = "main.png";
        }
        return this.oldSkinName;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean template) {
        this.isTemplate = template;
    }

    public CharacterRuntime getCharacterRuntime() {
        return this.characterRuntime;
    }

    public void setCharacterRuntime(CharacterRuntime characterRuntime) {
        this.characterRuntime = characterRuntime;
    }

    public CharacterStory getCharacterStory() {
        return this.characterRuntime.getCharacterStory();
    }

    private record ItemSlotData(int id, String data, String equipmentSlot) {
        public class_1799 getItem() {
            class_1792 item = (class_1792)class_7923.field_41178.method_10200(this.id);
            class_1799 itemStack = new class_1799((class_1935)item);
            class_2487 tag = Util.tagFromIdAndComponents(item, this.data);
            itemStack.method_7980(tag);
            return itemStack;
        }
    }
}

