/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.animation;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer2D;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import fr.loudo.narrativecraft.narrative.story.text.ParsedDialog;
import fr.loudo.narrativecraft.narrative.story.text.TextEffectAnimation;
import fr.loudo.narrativecraft.options.NarrativeClientOption;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.joml.Vector2f;

public class DialogScrollText {
    private final NarrativeClientOption clientOption = NarrativeCraftMod.getInstance().getNarrativeClientOptions();
    private final DialogRenderer dialogRenderer;
    private final class_310 minecraft;
    private final List<LetterLocation> lettersRenderer = new ArrayList<LetterLocation>();
    private TextEffectAnimation textEffectAnimation;
    private List<String> lines = new ArrayList<String>();
    private int currentLine;
    private int currentCharIndex;
    private float currentX;
    private float currentY;
    private float tickAccumulator = 0.0f;

    public DialogScrollText(DialogRenderer dialogRenderer, class_310 minecraft) {
        this.dialogRenderer = dialogRenderer;
        this.minecraft = minecraft;
        ParsedDialog parsedDialog = ParsedDialog.parse(dialogRenderer.getText());
        this.setText(parsedDialog.cleanedText());
    }

    public void reset() {
        this.currentLine = 0;
        this.currentCharIndex = 0;
        this.tickAccumulator = 0.0f;
        this.currentY = 0.0f;
        if (this.dialogRenderer instanceof DialogRenderer2D) {
            if (this.lines.size() > 1) {
                Objects.requireNonNull(this.minecraft.field_1772);
                float f = (9.0f + this.dialogRenderer.getGap()) * (float)(this.lines.size() - 1);
                Objects.requireNonNull(this.minecraft.field_1772);
                this.currentY -= (f + 9.0f) / 2.0f + 0.7f;
            } else {
                Objects.requireNonNull(this.minecraft.field_1772);
                this.currentY -= 9.0f / 2.0f;
            }
        } else {
            this.currentY = -this.dialogRenderer.getTotalHeight() + this.dialogRenderer.getPaddingY() + 0.7f;
        }
        this.currentX = -this.dialogRenderer.getTotalWidth() + this.dialogRenderer.getPaddingX() * 2.0f;
        this.lettersRenderer.clear();
        this.textEffectAnimation = new TextEffectAnimation(this.dialogRenderer.getText());
    }

    public void forceFinish() {
        while (!this.isFinished()) {
            this.addLetter();
        }
    }

    public void tick() {
        if (!this.isFinished() && !this.dialogRenderer.isAnimating()) {
            this.tickAccumulator += 1.0f;
            this.populateLetters();
        }
        this.textEffectAnimation.tick();
    }

    public void render(class_4587 poseStack, class_4597.class_4598 source, float partialTick) {
        Map<Integer, Vector2f> offsets = this.textEffectAnimation.getOffsets(partialTick);
        for (int i = 0; i < this.lettersRenderer.size(); ++i) {
            LetterLocation letter = this.lettersRenderer.get(i);
            if (!letter.render()) continue;
            float x = letter.x;
            float y = letter.y;
            if (offsets.containsKey(i)) {
                x += offsets.get((Object)Integer.valueOf((int)i)).x;
                y += offsets.get((Object)Integer.valueOf((int)i)).y;
            }
            this.minecraft.field_1772.method_27521(String.valueOf(letter.letter), x, y, class_5253.class_8045.method_48343((int)255, (int)this.dialogRenderer.getTextColor()), false, poseStack.method_23760().method_23761(), (class_4597)this.minecraft.method_22940().method_23000(), class_327.class_6415.field_33994, 0, 0xF000F0);
        }
        source.method_22993();
    }

    public void render(class_332 guiGraphics, float partialTick) {
        Map<Integer, Vector2f> offsets = this.textEffectAnimation.getOffsets(partialTick);
        for (int i = 0; i < this.lettersRenderer.size(); ++i) {
            LetterLocation letter = this.lettersRenderer.get(i);
            if (!letter.render()) continue;
            float x = letter.x;
            float y = letter.y;
            DialogRenderer dialogRenderer = this.dialogRenderer;
            if (dialogRenderer instanceof DialogRenderer3D) {
                DialogRenderer3D dialogRenderer3D = (DialogRenderer3D)dialogRenderer;
                if (dialogRenderer3D.getDialogOffset().y < 0.0f) {
                    y += dialogRenderer3D.getTotalHeight() - dialogRenderer3D.getPaddingY();
                }
            }
            if (offsets.containsKey(i)) {
                x += offsets.get((Object)Integer.valueOf((int)i)).x;
                y += offsets.get((Object)Integer.valueOf((int)i)).y;
            }
            this.drawStringPoseStack(String.valueOf(letter.letter), guiGraphics.method_51448(), (class_4597)guiGraphics.method_51450(), x, y);
        }
    }

    private void drawStringPoseStack(String character, class_4587 poseStack, class_4597 bufferSource, float x, float y) {
        class_310 client = class_310.method_1551();
        int color = this.dialogRenderer.getTextColor();
        client.field_1772.method_27521(character, x, y, color, false, poseStack.method_23760().method_23761(), bufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
    }

    public boolean isFinished() {
        return this.currentLine == this.lines.size() - 1 && this.currentCharIndex == this.lines.get(this.lines.size() - 1).length();
    }

    public String getLongerTextLine() {
        float longerSentenceWidth = 0.0f;
        String longerText = "";
        for (String line : this.lines) {
            float width = 0.0f;
            for (int i = 0; i < line.length(); ++i) {
                width += Util.getLetterWidth(line.codePointAt(i), this.minecraft);
            }
            if (!(width > longerSentenceWidth)) continue;
            longerSentenceWidth = width;
            longerText = line;
        }
        return longerText;
    }

    public void setText(String text) {
        text = text.replace("\n", "");
        this.lines = this.splitText(text);
    }

    private List<String> splitText(String text) {
        ArrayList<String> finalString = new ArrayList<String>();
        class_310 client = class_310.method_1551();
        List charSequences = client.field_1772.method_1728(class_5348.method_29430((String)text), (int)this.dialogRenderer.getWidth());
        for (class_5481 chara : charSequences) {
            StringBuilder stringBuilder = new StringBuilder();
            chara.accept((i, style, i1) -> {
                stringBuilder.appendCodePoint(i1);
                return true;
            });
            finalString.add(stringBuilder.toString());
        }
        return finalString;
    }

    private void populateLetters() {
        boolean playSound = false;
        while (this.tickAccumulator >= (float)this.currentLine && this.currentLine < this.lines.size()) {
            if (this.addLetter() != ' ') {
                playSound = true;
            }
            this.tickAccumulator -= this.clientOption.textSpeed;
        }
        if (playSound) {
            this.playLetterSound();
        }
    }

    private char addLetter() {
        if (this.currentLine >= this.lines.size()) {
            return ' ';
        }
        String currentLineText = this.lines.get(this.currentLine);
        if (currentLineText.isEmpty() || this.currentCharIndex >= currentLineText.length()) {
            if (this.lines.size() > 1 && this.currentLine < this.lines.size() - 1) {
                this.moveToNextLine();
            }
            return ' ';
        }
        char letter = currentLineText.charAt(this.currentCharIndex);
        this.lettersRenderer.add(new LetterLocation(letter, this.currentX, this.currentY, true));
        this.currentX += Util.getLetterWidth(letter, this.minecraft) + this.dialogRenderer.getLetterSpacing();
        ++this.currentCharIndex;
        if (this.currentCharIndex >= currentLineText.length() && this.lines.size() > 1 && this.currentLine < this.lines.size() - 1) {
            this.moveToNextLine();
        }
        return letter;
    }

    private void moveToNextLine() {
        this.lettersRenderer.add(new LetterLocation(' ', this.currentX, this.currentY, false));
        ++this.currentLine;
        this.currentCharIndex = 0;
        this.currentX = -this.dialogRenderer.getTotalWidth() + this.dialogRenderer.getPaddingX() * 2.0f;
        Objects.requireNonNull(this.minecraft.field_1772);
        this.currentY += 9.0f + this.dialogRenderer.getGap();
    }

    private void playLetterSound() {
        float pitch = 0.8f + new Random().nextFloat() * 0.4f;
        class_2960 soundRes = new class_2960("minecraft", "sfx.dialog_sound");
        class_3414 soundEvent = class_3414.method_47908((class_2960)soundRes);
        this.minecraft.field_1724.method_5783(soundEvent, 1.0f, pitch);
    }

    public List<String> getLines() {
        return this.lines;
    }

    private record LetterLocation(char letter, float x, float y, boolean render) {
    }
}

