/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions.manager;

import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.recording.Recording;
import fr.loudo.narrativecraft.narrative.recording.actions.AbstractHorseByteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.ActionsData;
import fr.loudo.narrativecraft.narrative.recording.actions.BoatBubbleAction;
import fr.loudo.narrativecraft.narrative.recording.actions.BoatPaddleAction;
import fr.loudo.narrativecraft.narrative.recording.actions.EntityByteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.ItemChangeAction;
import fr.loudo.narrativecraft.narrative.recording.actions.LivingEntityByteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.PoseAction;
import fr.loudo.narrativecraft.narrative.recording.actions.modsListeners.EmoteCraftListeners;
import fr.loudo.narrativecraft.narrative.recording.actions.modsListeners.ModsListenerImpl;
import fr.loudo.narrativecraft.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_4050;
import net.minecraft.class_7923;

public class ActionDifferenceListener {
    private final List<class_1304> equipmentSlotList = Arrays.asList(class_1304.field_6173, class_1304.field_6171, class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166);
    private final ActionsData actionsData;
    private final Recording recording;
    private class_4050 poseState;
    private byte entityByteState;
    private byte livingEntityByteState;
    private byte abstractHorseEntityByteState;
    private int BoatEntityBubbleState;
    private boolean BoatEntityLeftPaddleState;
    private boolean BoatEntityRightPaddleState;
    private final HashMap<class_1304, class_1799> currentItemInEquipmentSlot;
    private List<ModsListenerImpl> modsListenerList;

    public ActionDifferenceListener(ActionsData actionsData, Recording recording) {
        this.actionsData = actionsData;
        this.currentItemInEquipmentSlot = new HashMap();
        this.recording = recording;
        this.BoatEntityLeftPaddleState = false;
        this.BoatEntityRightPaddleState = false;
        this.initItemSlot();
        this.initModsListeners();
    }

    private void initItemSlot() {
        for (class_1304 equipmentSlot : this.equipmentSlotList) {
            this.currentItemInEquipmentSlot.put(equipmentSlot, new class_1799((class_1935)class_1802.field_8162));
        }
    }

    private void initModsListeners() {
        this.modsListenerList = new ArrayList<ModsListenerImpl>();
        if (Services.PLATFORM.isModLoaded("emotecraft")) {
            EmoteCraftListeners emoteCraftListeners = new EmoteCraftListeners(this);
            emoteCraftListeners.start();
            this.modsListenerList.add(emoteCraftListeners);
        }
    }

    public void listenDifference() {
        if (this.actionsData.getEntity() instanceof class_1309) {
            this.poseListener();
            this.entityByteListener();
            this.livingEntityByteListener();
            this.itemListener();
        }
    }

    private void poseListener() {
        if (this.actionsData.getEntity().method_18376() != this.poseState) {
            PoseAction action = new PoseAction(this.recording.getTick(), this.actionsData.getEntity().method_18376(), this.poseState);
            this.poseState = this.actionsData.getEntity().method_18376();
            this.actionsData.addAction(action);
        }
    }

    private void entityByteListener() {
        byte entityCurrentByte = (Byte)this.actionsData.getEntity().method_5841().method_12789(EntityAccessor.getDATA_SHARED_FLAGS_ID());
        if (this.entityByteState != entityCurrentByte) {
            EntityByteAction entityByteAction = new EntityByteAction(this.recording.getTick(), entityCurrentByte, this.entityByteState);
            this.entityByteState = entityCurrentByte;
            this.actionsData.addAction(entityByteAction);
        }
    }

    private void livingEntityByteListener() {
        byte livingEntityCurrentByte = (Byte)this.actionsData.getEntity().method_5841().method_12789(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS());
        if (this.livingEntityByteState != livingEntityCurrentByte) {
            LivingEntityByteAction livingEntityByteAction = new LivingEntityByteAction(this.recording.getTick(), livingEntityCurrentByte, this.livingEntityByteState);
            this.livingEntityByteState = livingEntityCurrentByte;
            this.actionsData.addAction(livingEntityByteAction);
        }
    }

    public void abstractHorseEntityByteListener(byte abstractHorseCurrentByte) {
        if (this.actionsData.getEntity() instanceof class_1496 && this.abstractHorseEntityByteState != abstractHorseCurrentByte) {
            AbstractHorseByteAction action = new AbstractHorseByteAction(this.recording.getTick(), abstractHorseCurrentByte, this.abstractHorseEntityByteState);
            this.abstractHorseEntityByteState = abstractHorseCurrentByte;
            this.actionsData.addAction(action);
        }
    }

    public void BoatEntityBubbleListener(int BoatCurrentBubble) {
        if (this.actionsData.getEntity() instanceof class_1690 && this.BoatEntityBubbleState != BoatCurrentBubble) {
            BoatBubbleAction action = new BoatBubbleAction(this.recording.getTick(), BoatCurrentBubble, this.BoatEntityBubbleState);
            this.BoatEntityBubbleState = BoatCurrentBubble;
            this.actionsData.addAction(action);
        }
    }

    public void BoatEntityPaddleListener(boolean left, boolean right) {
        if (this.actionsData.getEntity() instanceof class_1690 && (this.BoatEntityLeftPaddleState != left || this.BoatEntityRightPaddleState != right)) {
            BoatPaddleAction action = new BoatPaddleAction(this.recording.getTick(), left, right, this.BoatEntityLeftPaddleState, this.BoatEntityRightPaddleState);
            this.BoatEntityLeftPaddleState = left;
            this.BoatEntityRightPaddleState = right;
            this.actionsData.addAction(action);
        }
    }

    private void itemListener() {
        for (class_1304 equipmentSlot : this.equipmentSlotList) {
            class_1799 itemFromSlot = this.currentItemInEquipmentSlot.get(equipmentSlot);
            class_1799 currentItemFromSlot = ((class_1309)this.actionsData.getEntity()).method_6118(equipmentSlot);
            if (class_7923.field_41178.method_10206((Object)itemFromSlot.method_7909()) == class_7923.field_41178.method_10206((Object)currentItemFromSlot.method_7909())) continue;
            this.currentItemInEquipmentSlot.replace(equipmentSlot, currentItemFromSlot.method_7972());
            this.onItemChange(currentItemFromSlot, itemFromSlot, equipmentSlot, this.recording.getTick());
        }
    }

    private void onItemChange(class_1799 itemStack, class_1799 oldItemStack, class_1304 equipmentSlot, int tick) {
        ItemChangeAction itemChangeAction = new ItemChangeAction(tick, equipmentSlot.name(), itemStack, oldItemStack);
        this.actionsData.addAction(itemChangeAction);
    }

    public Recording getRecording() {
        return this.recording;
    }

    public List<ModsListenerImpl> getModsListenerList() {
        return this.modsListenerList;
    }

    public ActionsData getActionsData() {
        return this.actionsData;
    }
}

