/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.MathHelper;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;

public class KeyframeOptionScreen<T extends Keyframe, E extends AbstractKeyframeController<T>>
extends class_437 {
    protected final int INITIAL_POS_X = 20;
    protected final int INITIAL_POS_Y = 15;
    protected final int EDIT_BOX_WIDTH = 60;
    protected final int EDIT_BOX_HEIGHT = 15;
    protected final int BUTTON_HEIGHT = 20;
    protected final List<class_342> coordinatesBoxList = new ArrayList<class_342>();
    protected final List<class_4185> littleButtons = new ArrayList<class_4185>();
    protected final class_3222 player;
    protected final PlayerSession playerSession;
    protected final T keyframe;
    protected final E keyframeController;
    protected Runnable reloadScreen;
    protected float upDownValue;
    protected float leftRightValue;
    protected float rotationValue;
    protected float fovValue;
    protected int currentY = 15;
    protected boolean hide;

    public KeyframeOptionScreen(T keyframe, E keyframeController, PlayerSession playerSession, boolean hide) {
        super((class_2561)class_2561.method_43470((String)"Keyframe Option"));
        this.keyframe = keyframe;
        this.player = playerSession.getPlayer();
        this.playerSession = playerSession;
        this.upDownValue = ((Keyframe)keyframe).getKeyframeLocation().getPitch();
        this.leftRightValue = ((Keyframe)keyframe).getKeyframeLocation().getYaw();
        this.rotationValue = ((Keyframe)keyframe).getKeyframeLocation().getRoll();
        this.fovValue = ((Keyframe)keyframe).getKeyframeLocation().getFov();
        this.hide = hide;
        this.keyframeController = keyframeController;
    }

    protected void method_25426() {
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 guiGraphics) {
    }

    protected class_342 addLabeledEditBox(class_2561 text, String defaultValue) {
        class_7842 labelWidget = ScreenUtils.text(text, this.field_22793, 20, this.currentY);
        class_342 editBox = new class_342(this.field_22793, 20 + labelWidget.method_25368() + 5, this.currentY - labelWidget.method_25364() / 2, 60, 15, (class_2561)class_2561.method_43470((String)(text.getString() + " Value")));
        editBox.method_1852(defaultValue);
        editBox.method_1890(s -> s.matches("^\\d*(\\.\\d*)?$"));
        this.method_37063((class_364)labelWidget);
        this.method_37063((class_364)editBox);
        this.currentY += 20;
        return editBox;
    }

    protected void initButtons() {
    }

    protected void initPositionLabelBox() {
        String[] labels;
        int currentX = 20;
        int editWidth = 50;
        int i = 0;
        KeyframeLocation position = ((Keyframe)this.keyframe).getKeyframeLocation();
        Double[] coords = new Double[]{position.getX(), position.getY(), position.getZ()};
        for (String label : labels = new String[]{"X:", "Y:", "Z:"}) {
            class_7842 stringWidget = ScreenUtils.text((class_2561)class_2561.method_43470((String)label), this.field_22793, currentX, this.currentY);
            class_342 box = new class_342(this.field_22793, currentX + stringWidget.method_25368() + 5, this.currentY - stringWidget.method_25364() / 2, editWidth, 15, (class_2561)class_2561.method_43470((String)(stringWidget + " Value")));
            box.method_1890(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
            box.method_1852(String.format(Locale.US, "%.2f", coords[i]));
            this.method_37063((class_364)stringWidget);
            this.method_37063((class_364)box);
            this.coordinatesBoxList.add(box);
            currentX += stringWidget.method_25368() + editWidth + 10;
            ++i;
        }
        this.currentY += 20;
    }

    protected void initTextSelectedKeyframe() {
    }

    protected void initLittleButtons() {
        T previousKeyframe;
        int currentX = this.field_22789 - 20;
        int gap = 5;
        int width = 20;
        if (this.hide) {
            class_4185 eyeClosed = class_4185.method_46430((class_2561)ImageFontConstants.EYE_CLOSED, button -> this.field_22787.method_1507(((AbstractKeyframeController)this.keyframeController).keyframeOptionScreen((Keyframe)this.keyframe, false))).method_46434(currentX - width / 2, 10, width, 20).method_46431();
            this.littleButtons.add(eyeClosed);
            this.method_37063((class_364)eyeClosed);
            return;
        }
        class_4185 closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2716"), button -> {
            ((AbstractKeyframeController)this.keyframeController).setCamera(null);
            this.field_22787.method_1507(null);
        }).method_46434(currentX - width / 2, 10, width, 20).method_46431();
        this.littleButtons.add(closeButton);
        T nextKeyframe = this.keyframeController.getNextKeyframe(this.keyframe);
        if (((Keyframe)nextKeyframe).getId() != ((Keyframe)this.keyframe).getId()) {
            class_4185 rightKeyframeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b6"), button -> NarrativeCraftMod.server.execute(() -> ((AbstractKeyframeController)this.keyframeController).setCamera((Keyframe)nextKeyframe))).method_46434((currentX -= 20 + gap) - width / 2, 10, width, 20).method_46431();
            this.method_37063((class_364)rightKeyframeButton);
        }
        if (((Keyframe)(previousKeyframe = this.keyframeController.getPreviousKeyframe(this.keyframe))).getId() != ((Keyframe)this.keyframe).getId()) {
            class_4185 leftKeyframeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25c0"), button -> NarrativeCraftMod.server.execute(() -> ((AbstractKeyframeController)this.keyframeController).setCamera((Keyframe)previousKeyframe))).method_46434((currentX -= 20 + gap) - width / 2, 10, width, 20).method_46431();
            this.littleButtons.add(leftKeyframeButton);
            this.method_37063((class_364)leftKeyframeButton);
        }
        this.method_37063((class_364)closeButton);
        class_4185 eyeOpen = class_4185.method_46430((class_2561)ImageFontConstants.EYE_OPEN, button -> this.field_22787.method_1507(((AbstractKeyframeController)this.keyframeController).keyframeOptionScreen((Keyframe)this.keyframe, true))).method_46434((currentX -= 20 + gap) - width / 2, 10, width, 20).method_46431();
        this.littleButtons.add(eyeOpen);
        this.method_37063((class_364)eyeOpen);
    }

    protected void initSliders() {
        int initialY = this.field_22790 - 50;
        int gap = 5;
        int numSliders = 4;
        int sliderWidth = (this.field_22789 - gap * (numSliders + 1)) / numSliders;
        int currentX = gap;
        final Function<Float, String> formatFloat = val -> String.format(Locale.US, "%.2f", val);
        float defaultXRot = ((Keyframe)this.keyframe).getKeyframeLocation().getPitch();
        float defaultValXRot = defaultXRot + 90.0f;
        class_357 upDownSlider = new class_357(currentX, initialY, sliderWidth, 20, (class_2561)Translation.message("screen.keyframe_option.up_down", formatFloat.apply(Float.valueOf(defaultValXRot))), defaultValXRot / 180.0f){

            protected void method_25346() {
                this.method_25355((class_2561)Translation.message("screen.keyframe_option.up_down", formatFloat.apply(Float.valueOf(this.getValue() + 90.0f))));
            }

            protected void method_25344() {
                KeyframeOptionScreen.this.upDownValue = this.getValue();
                KeyframeOptionScreen.this.updateValues();
            }

            public float getValue() {
                return (float)(this.field_22753 * 180.0 - 90.0);
            }
        };
        class_342 upDownBox = new class_342(this.field_22793, currentX, initialY + 20 + 5, 60, 15, (class_2561)class_2561.method_43470((String)"Up Down Value"));
        upDownBox.method_1852(formatFloat.apply(Float.valueOf(defaultValXRot)));
        upDownBox.method_1890(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        class_4185 upDownButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2714"), btn -> {
            try {
                this.upDownValue = Float.parseFloat(upDownBox.method_1882()) - 90.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).method_46434(currentX + 60 + 5, upDownBox.method_46427(), 20, 15).method_46431();
        this.method_37063((class_364)upDownSlider);
        this.method_37063((class_364)upDownBox);
        this.method_37063((class_364)upDownButton);
        float defaultYRot = MathHelper.wrapDegrees360(((Keyframe)this.keyframe).getKeyframeLocation().getYaw());
        class_357 leftRightSlider = new class_357(currentX += sliderWidth + gap, initialY, sliderWidth, 20, (class_2561)Translation.message("screen.keyframe_option.left_right", formatFloat.apply(Float.valueOf(defaultYRot))), defaultYRot / 360.0f){

            protected void method_25346() {
                float value = MathHelper.wrapDegrees360(((Keyframe)KeyframeOptionScreen.this.keyframe).getKeyframeLocation().getYaw());
                if (value == 0.0f && this.field_22753 == 1.0) {
                    value = 360.0f;
                }
                this.method_25355((class_2561)Translation.message("screen.keyframe_option.left_right", formatFloat.apply(Float.valueOf(value))));
            }

            protected void method_25344() {
                KeyframeOptionScreen.this.leftRightValue = this.getValue();
                KeyframeOptionScreen.this.updateValues();
            }

            public float getValue() {
                return class_3532.method_15393((float)((float)(this.field_22753 * 360.0)));
            }
        };
        class_342 leftRightBox = new class_342(this.field_22793, currentX, initialY + 20 + 5, 60, 15, (class_2561)class_2561.method_43470((String)"Left Right Value"));
        leftRightBox.method_1852(formatFloat.apply(Float.valueOf(defaultYRot)));
        leftRightBox.method_1890(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        class_4185 leftRightButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2714"), btn -> {
            try {
                this.leftRightValue = Float.parseFloat(leftRightBox.method_1882());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).method_46434(currentX + 60 + 5, leftRightBox.method_46427(), 20, 15).method_46431();
        this.method_37063((class_364)leftRightSlider);
        this.method_37063((class_364)leftRightBox);
        this.method_37063((class_364)leftRightButton);
        float defaultZRot = class_3532.method_15393((float)((Keyframe)this.keyframe).getKeyframeLocation().getRoll());
        class_357 rotationSlider = new class_357(currentX += sliderWidth + gap, initialY, sliderWidth, 20, (class_2561)Translation.message("screen.keyframe_option.rotation", formatFloat.apply(Float.valueOf(defaultZRot))), (((Keyframe)this.keyframe).getKeyframeLocation().getRoll() + 180.0f) % 360.0f / 360.0f){

            protected void method_25346() {
                float angle = (float)(this.field_22753 * 360.0 - 180.0);
                this.method_25355((class_2561)Translation.message("screen.keyframe_option.rotation", formatFloat.apply(Float.valueOf(angle))));
            }

            protected void method_25344() {
                float angle = (float)(this.field_22753 * 360.0 - 180.0);
                KeyframeOptionScreen.this.rotationValue = (angle + 360.0f) % 360.0f;
                KeyframeOptionScreen.this.updateValues();
            }
        };
        class_342 rotationBox = new class_342(this.field_22793, currentX, initialY + 20 + 5, 60, 15, (class_2561)class_2561.method_43470((String)"Rotation Value"));
        rotationBox.method_1852(formatFloat.apply(Float.valueOf(defaultZRot)));
        rotationBox.method_1890(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        class_4185 rotationButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2714"), btn -> {
            try {
                float angle = Float.parseFloat(rotationBox.method_1882());
                this.rotationValue = (angle + 360.0f) % 360.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).method_46434(currentX + 60 + 5, rotationBox.method_46427(), 20, 15).method_46431();
        this.method_37063((class_364)rotationSlider);
        this.method_37063((class_364)rotationBox);
        this.method_37063((class_364)rotationButton);
        float defaultFov = ((Keyframe)this.keyframe).getKeyframeLocation().getFov();
        class_357 fovSlider = new class_357(currentX += sliderWidth + gap, initialY, sliderWidth, 20, (class_2561)Translation.message("screen.keyframe_option.fov", formatFloat.apply(Float.valueOf(defaultFov))), defaultFov / 150.0f){

            protected void method_25346() {
                this.method_25355((class_2561)Translation.message("screen.keyframe_option.fov", formatFloat.apply(Float.valueOf(this.getValue()))));
            }

            protected void method_25344() {
                KeyframeOptionScreen.this.fovValue = this.getValue();
                KeyframeOptionScreen.this.updateValues();
            }

            public float getValue() {
                return (float)(this.field_22753 * 150.0);
            }
        };
        class_342 fovBox = new class_342(this.field_22793, currentX, initialY + 20 + 5, 60, 15, (class_2561)class_2561.method_43470((String)"FOV Value"));
        fovBox.method_1852(formatFloat.apply(Float.valueOf(defaultFov)));
        fovBox.method_1890(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        class_4185 fovButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2714"), btn -> {
            try {
                this.fovValue = Float.parseFloat(fovBox.method_1882());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).method_46434(currentX + 60 + 5, fovBox.method_46427(), 20, 15).method_46431();
        this.method_37063((class_364)fovSlider);
        this.method_37063((class_364)fovBox);
        this.method_37063((class_364)fovButton);
    }

    protected void updateValues() {
    }

    public boolean isHide() {
        return this.hide;
    }
}

