/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class StoryElementList
extends class_4280<Entry> {
    public StoryElementList(class_310 minecraft, class_437 screen, List<StoryEntryData> entriesData, boolean editButton) {
        super(minecraft, screen.field_22789, screen.field_22790, 32, screen.field_22790 - 65, 24);
        this.method_29344(false);
        for (StoryEntryData data : entriesData) {
            this.method_25321((class_350.class_351)new Entry(data, screen, editButton));
        }
    }

    public static class StoryEntryData {
        public final class_4185 mainButton;
        public List<class_4185> extraButtons;
        public Runnable onDelete;
        public Runnable onUpdate;

        public StoryEntryData(class_4185 mainButton, List<class_4185> extraButtons, Runnable onUpdate, Runnable onDelete) {
            this.mainButton = mainButton;
            this.extraButtons = extraButtons;
            this.onUpdate = onUpdate;
            this.onDelete = onDelete;
        }

        public StoryEntryData(class_4185 mainButton, Runnable onUpdate, Runnable onDelete) {
            this.mainButton = mainButton;
            this.onUpdate = onUpdate;
            this.onDelete = onDelete;
        }

        public StoryEntryData(class_4185 mainButton) {
            this.mainButton = mainButton;
        }
    }

    public static class Entry
    extends class_4280.class_4281<Entry> {
        private final int gap = 5;
        private final class_4185 mainButton;
        private final List<class_4185> buttons;
        private final class_437 screen;

        public Entry(StoryEntryData data, class_437 screen, boolean editButton) {
            this.screen = screen;
            this.mainButton = data.mainButton;
            this.buttons = new ArrayList<class_4185>();
            this.buttons.add(this.mainButton);
            if (data.onUpdate != null && editButton) {
                this.buttons.add(this.createEditButton(data.onUpdate));
                this.buttons.add(this.createRemoveButton(data.onDelete));
            }
            if (data.extraButtons != null) {
                data.extraButtons.forEach(button -> button.method_25358(20));
                this.buttons.addAll(data.extraButtons);
            }
        }

        private class_4185 createEditButton(Runnable onUpdate) {
            return class_4185.method_46430((class_2561)ImageFontConstants.EDIT, btn -> onUpdate.run()).method_46432(20).method_46431();
        }

        private class_4185 createRemoveButton(Runnable onDelete) {
            return class_4185.method_46430((class_2561)ImageFontConstants.REMOVE, btn -> {
                class_410 confirm = new class_410(b -> {
                    if (b) {
                        onDelete.run();
                    } else {
                        class_310.method_1551().method_1507(this.screen);
                    }
                }, (class_2561)class_2561.method_43470((String)""), (class_2561)Translation.message("global.confirm_delete", new Object[0]), class_5244.field_24336, class_5244.field_24335);
                class_310.method_1551().method_1507((class_437)confirm);
            }).method_46432(20).method_46431();
        }

        public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partial) {
            int totalWidth = this.buttons.stream().mapToInt(class_339::method_25368).sum() + (this.buttons.size() - 1) * 5;
            int x = this.screen.field_22789 / 2 - totalWidth / 2;
            if (this.buttons.size() > 1) {
                x -= 5;
            }
            for (class_4185 button : this.buttons) {
                button.method_48229(x, top);
                button.method_25394(graphics, mouseX, mouseY, partial);
                x += button.method_25368() + 5;
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            for (class_4185 btn : this.buttons) {
                if (!btn.method_25402(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            for (class_4185 btn : this.buttons) {
                btn.method_25406(mouseX, mouseY, button);
            }
            return false;
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
            for (class_4185 btn : this.buttons) {
                btn.method_25403(mouseX, mouseY, button, dragX, dragY);
            }
            return false;
        }

        public class_2561 method_37006() {
            return this.mainButton.method_25369();
        }
    }
}

