/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.story;

import com.bladecoder.ink.runtime.Choice;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.keys.ModKeys;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.screens.components.ChoiceButtonWidget;
import fr.loudo.narrativecraft.util.MathHelper;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class StoryChoicesScreen
extends class_437 {
    private static final double APPEAR_TIME = 0.25;
    private static final int OFFSET = 10;
    private final List<Choice> choiceList;
    private final List<AnimatedChoice> animatedChoices;
    private final List<ChoiceButtonWidget> choiceButtonWidgetList = new ArrayList<ChoiceButtonWidget>();
    private final int totalTick;
    private PlayerSession playerSession;
    private StoryHandler storyHandler;
    private boolean initiated;
    private double t;
    private int currentTick;

    public StoryChoicesScreen(PlayerSession playerSession, boolean animate) {
        super((class_2561)class_2561.method_43470((String)"Choice screen"));
        this.playerSession = playerSession;
        this.storyHandler = playerSession.getStoryHandler();
        this.choiceList = playerSession.getStoryHandler().getStory().getCurrentChoices();
        this.animatedChoices = new ArrayList<AnimatedChoice>();
        this.initiated = !animate;
        this.totalTick = 5;
    }

    public StoryChoicesScreen(List<Choice> choiceList, boolean animate) {
        super((class_2561)class_2561.method_43470((String)"Choice screen"));
        this.choiceList = choiceList;
        this.animatedChoices = new ArrayList<AnimatedChoice>();
        this.initiated = !animate;
        this.totalTick = 5;
    }

    public static StoryChoicesScreen fromStrings(List<String> stringChoiceList) {
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (String choiceString : stringChoiceList) {
            Choice choice = new Choice();
            choice.setIndex(0);
            choice.setText(choiceString);
            choices.add(choice);
        }
        return new StoryChoicesScreen(choices, true);
    }

    public void method_25393() {
        super.method_25393();
        if (this.currentTick < this.totalTick) {
            ++this.currentTick;
        }
        for (ChoiceButtonWidget choiceButtonWidget : this.choiceButtonWidgetList) {
            choiceButtonWidget.tick();
        }
    }

    protected void method_25426() {
        int i;
        if (!this.initiated) {
            class_2960 soundRes = new class_2960("minecraft", "sfx.choice_appear");
            class_3414 sound = class_3414.method_47908((class_2960)soundRes);
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)1.0f, (float)1.0f));
        }
        this.choiceButtonWidgetList.clear();
        for (Choice choice : this.choiceList) {
            this.choiceButtonWidgetList.add(new ChoiceButtonWidget(choice, index -> {
                this.field_22787.method_1507(null);
                NarrativeCraftMod.server.execute(() -> this.storyHandler.chooseChoiceAndNext((int)index));
            }));
        }
        int spacing = 10;
        int baseY = 60;
        int maxWidthUpDown = 0;
        for (i = 0; i < this.choiceButtonWidgetList.size(); ++i) {
            if (i % 2 == 0 || this.choiceButtonWidgetList.get(i).method_25368() <= maxWidthUpDown) continue;
            maxWidthUpDown = this.choiceButtonWidgetList.get(i).method_25368();
        }
        for (i = 0; i < this.choiceButtonWidgetList.size(); ++i) {
            ChoiceButtonWidget choiceButtonWidget = this.choiceButtonWidgetList.get(i);
            choiceButtonWidget.setOpacity(5);
            choiceButtonWidget.setCanPress(false);
            int currentX = 0;
            int offsetX = 0;
            int offsetY = 0;
            int currentY = this.field_22790 - baseY;
            if (this.choiceButtonWidgetList.size() == 4) {
                currentY -= choiceButtonWidget.method_25364();
            }
            switch (i) {
                case 0: {
                    currentX = this.choiceButtonWidgetList.size() == 1 ? this.field_22789 / 2 - choiceButtonWidget.method_25368() / 2 : (this.choiceButtonWidgetList.size() > 2 ? this.field_22789 / 2 - choiceButtonWidget.method_25368() - maxWidthUpDown / 2 : this.field_22789 / 2 - choiceButtonWidget.method_25368() - spacing);
                    offsetX = 10;
                    break;
                }
                case 1: {
                    if (this.choiceButtonWidgetList.size() > 2) {
                        currentY -= choiceButtonWidget.method_25364() + spacing;
                        currentX = this.field_22789 / 2 - choiceButtonWidget.method_25368() / 2;
                        offsetY = 10;
                        break;
                    }
                    currentX = this.field_22789 / 2 + spacing;
                    offsetX = -10;
                    break;
                }
                case 2: {
                    currentX = this.field_22789 / 2 + maxWidthUpDown / 2;
                    offsetX = -10;
                    break;
                }
                case 3: {
                    currentY += choiceButtonWidget.method_25364() + spacing;
                    currentX = this.field_22789 / 2 - choiceButtonWidget.method_25368() / 2;
                    offsetY = -10;
                }
            }
            choiceButtonWidget.method_46421(currentX);
            choiceButtonWidget.method_46419(currentY);
            this.method_37063((class_364)choiceButtonWidget);
            AnimatedChoice animatedChoice = new AnimatedChoice(choiceButtonWidget, offsetX, offsetY);
            this.animatedChoices.add(animatedChoice);
        }
        if (!this.initiated) {
            this.t = 0.0;
            this.initiated = true;
        } else {
            this.t = 1.0;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return false;
        }
        if (this.storyHandler == null) {
            this.field_22787.method_1507(null);
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        List<class_304> choiceKeys = List.of(ModKeys.SELECT_CHOICE_1, ModKeys.SELECT_CHOICE_2, ModKeys.SELECT_CHOICE_3, ModKeys.SELECT_CHOICE_4);
        for (int i = 0; i < this.storyHandler.getStory().getCurrentChoices().size(); ++i) {
            if (keyCode != choiceKeys.get(i).method_1429().method_1444()) continue;
            this.field_22787.method_1507(null);
            try {
                int finalI = i;
                NarrativeCraftMod.server.execute(() -> this.storyHandler.chooseChoiceAndNext(finalI));
                continue;
            }
            catch (Exception e) {
                this.storyHandler.stop();
                Util.sendCrashMessage((class_1657)this.field_22787.field_1724, e);
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.t = MathHelper.clamp((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), 0.0, 1.0);
        for (AnimatedChoice ac : this.animatedChoices) {
            int newOpacity = (int)class_3532.method_16436((double)this.t, (double)5.0, (double)255.0);
            guiGraphics.method_51448().method_22903();
            if (this.choiceList.size() > 1) {
                guiGraphics.method_51448().method_46416((float)class_3532.method_16436((double)this.t, (double)ac.offsetX, (double)0.0), (float)class_3532.method_16436((double)this.t, (double)ac.offsetY, (double)0.0), 0.0f);
            }
            ac.widget.setOpacity(newOpacity);
            ac.widget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.method_51448().method_22909();
            if (!(this.t >= 1.0)) continue;
            ac.widget.setCanPress(true);
        }
    }

    protected void method_48640() {
        this.animatedChoices.clear();
        super.method_48640();
    }

    public void method_25419() {
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 guiGraphics) {
    }

    private record AnimatedChoice(ChoiceButtonWidget widget, int offsetX, int offsetY) {
    }
}

