/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.util;

public class MathHelper {
    public static float wrapDegrees360(float value) {
        return (value + 360.0f) % 360.0f;
    }

    public static int secondsToTick(float seconds) {
        return (int)(seconds * 20.0f);
    }

    public static double tickToSeconds(int tick) {
        return (double)tick / 20.0;
    }

    public static float catmullRom(float p0, float p1, float p2, float p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return 0.5f * (2.0f * p1 + (-p0 + p2) * t + (2.0f * p0 - 5.0f * p1 + 4.0f * p2 - p3) * t2 + (-p0 + 3.0f * p1 - 3.0f * p2 + p3) * t3);
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }
}

