/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog;

import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.animation.DialogArrowSkip;
import fr.loudo.narrativecraft.util.Easing;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5253;

public class DialogRenderer2D
extends DialogRenderer {
    private int widthBox;
    private int heightBox;
    private int offsetHeight;

    public DialogRenderer2D(String text, int widthText, int widthBox, int heightBox, int offsetHeight, float letterSpacing, float gap, int backgroundColor, int textColor) {
        super(text.trim(), widthText, 0.0f, 0.0f, 1.0f, letterSpacing, gap, backgroundColor, textColor);
        this.offsetHeight = offsetHeight;
        this.dialogArrowSkip = new DialogArrowSkip(this, 3.5f, 3.5f, -5.0f, -6.0f, -1);
        this.widthBox = widthBox;
        this.heightBox = heightBox;
        this.dialogAppearTime = 0.4;
    }

    public DialogRenderer2D(String text, int widthText, int widthBox, int heightBox, int offsetHeight, DialogData dialogData) {
        super(text.trim(), widthText, 0.0f, 0.0f, 1.0f, dialogData.getLetterSpacing(), dialogData.getGap(), dialogData.getBackgroundColor(), dialogData.getTextColor());
        this.offsetHeight = offsetHeight;
        this.dialogArrowSkip = new DialogArrowSkip(this, 3.5f, 3.5f, -5.0f, -6.0f, -1);
        this.widthBox = widthBox;
        this.heightBox = heightBox;
        this.dialogAppearTime = 0.4;
    }

    @Override
    public void render(class_332 guiGraphics, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        float originalScale = this.scale;
        if (this.currentTick < this.totalTick) {
            double t = this.t(partialTick);
            t = Easing.SMOOTH.interpolate(t);
            if (this.dialogStarting || this.dialogStopping) {
                double opacity;
                if (this.dialogStarting) {
                    originalScale = (float)class_3532.method_16436((double)t, (double)0.8, (double)this.scale);
                    opacity = class_3532.method_16436((double)t, (double)0.0, (double)1.0);
                } else {
                    originalScale = (float)class_3532.method_16436((double)t, (double)this.scale, (double)0.8);
                    opacity = class_3532.method_16436((double)t, (double)0.8, (double)0.0);
                }
                this.backgroundColor = class_5253.class_5254.method_58144((int)((int)(opacity * 255.0)), (int)this.backgroundColor);
            }
        }
        if (this.currentTick == this.totalTick) {
            if (this.dialogStopping && !this.dialogStarting) {
                this.dialogStopping = false;
            }
            if (this.dialogStarting && !this.dialogStopping) {
                this.dialogStarting = false;
            }
        }
        int windowWidth = this.minecraft.method_22683().method_4486();
        int windowHeight = this.minecraft.method_22683().method_4502();
        int offsetDialog = this.offsetHeight;
        int guiScale = (Integer)this.minecraft.field_1690.method_42474().method_41753();
        switch (guiScale) {
            case 1: {
                offsetDialog *= 4;
            }
            case 2: {
                offsetDialog *= 2;
            }
        }
        int centerX = windowWidth / 2;
        int centerY = windowHeight - offsetDialog - this.heightBox / 2;
        poseStack.method_46416((float)centerX, (float)centerY, 0.0f);
        poseStack.method_22905(originalScale, originalScale, originalScale);
        poseStack.method_46416((float)(-this.widthBox) / 2.0f, (float)(-this.heightBox) / 2.0f, 0.0f);
        guiGraphics.method_25294(0, 0, this.widthBox, this.heightBox, this.backgroundColor);
        poseStack.method_46416((float)this.widthBox / 2.0f - 4.0f, (float)this.heightBox / 2.0f, 0.0f);
        if (!this.dialogStopping) {
            this.dialogScrollText.render(guiGraphics, partialTick);
            if (this.dialogScrollText.isFinished()) {
                if (!this.dialogAutoSkipping) {
                    this.dialogAutoSkipping = true;
                    this.currentTick = 0;
                }
                this.dialogArrowSkip.start();
            }
            if (!this.noSkip) {
                poseStack.method_22903();
                poseStack.method_46416((float)this.widthBox / 2.0f, (float)this.heightBox / 2.0f - 10.0f, 0.0f);
                this.dialogArrowSkip.render(guiGraphics, partialTick);
                poseStack.method_22909();
            }
        }
        poseStack.method_22909();
    }

    public int getWidthBox() {
        return this.widthBox;
    }

    public void setWidthBox(int widthBox) {
        this.widthBox = widthBox;
    }

    public int getHeightBox() {
        return this.heightBox;
    }

    public void setHeightBox(int heightBox) {
        this.heightBox = heightBox;
    }

    public int getOffsetHeight() {
        return this.offsetHeight;
    }

    public void setOffsetHeight(int offsetHeight) {
        this.offsetHeight = offsetHeight;
    }
}

