/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.geometric;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

public class DialogTail {
    private final DialogRenderer3D dialog;
    private float width;
    private float height;
    private float offset;

    public DialogTail(DialogRenderer3D dialog, float width, float height, float offset) {
        this.dialog = dialog;
        this.width = width;
        this.height = height;
        this.offset = offset;
    }

    public void render(class_4587 poseStack, float partialTick, class_4597.class_4598 bufferSource, class_4184 camera) {
        TailDirection tailDirection = TailDirection.TOP;
        if (this.dialog.getDialogOffset().x > 0.0f) {
            tailDirection = TailDirection.LEFT;
        } else if (this.dialog.getDialogOffset().x < 0.0f) {
            tailDirection = TailDirection.RIGHT;
        } else if (this.dialog.getDialogOffset().y > 0.0f) {
            tailDirection = TailDirection.BOTTOM;
        }
        class_241 tailOffset = this.getTailOffset(camera);
        poseStack.method_22903();
        if (this.dialog.getDialogOffset().x != 0.0f) {
            if (this.dialog.getDialogOffset().y < 0.0f) {
                poseStack.method_46416(0.0f, this.height / 2.0f - this.width / 2.0f, 0.0f);
            } else if (this.dialog.getDialogOffset().y > 0.0f) {
                poseStack.method_46416(0.0f, -(this.height / 2.0f) + this.width / 2.0f, 0.0f);
            }
        }
        if (tailDirection == TailDirection.RIGHT || tailDirection == TailDirection.LEFT) {
            float halfHeight = this.dialog.getHeight() / 2.0f;
            float minY = -halfHeight + this.width / 2.0f;
            float maxY = halfHeight - this.width / 2.0f;
            if (this.dialog.getDialogOffset().y != 0.0f) {
                if (tailOffset.field_1342 < minY) {
                    tailDirection = TailDirection.valueOf(tailDirection.name() + "_UP_CORNER");
                } else if (tailOffset.field_1342 > maxY) {
                    tailDirection = TailDirection.valueOf(tailDirection.name() + "_DOWN_CORNER");
                }
            }
        }
        class_4588 vertexConsumer = bufferSource.getBuffer(NarrativeCraftMod.dialogBackgroundRenderType);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        float topRight = -this.width / 2.0f + this.offset;
        float topLeft = this.width / 2.0f + this.offset;
        switch (tailDirection.ordinal()) {
            case 0: {
                this.drawTailTop(matrix4f, vertexConsumer, topRight, topLeft);
                break;
            }
            case 1: {
                this.drawTailBottom(matrix4f, vertexConsumer, topRight, topLeft);
                break;
            }
            case 5: {
                this.drawTailRight(matrix4f, vertexConsumer);
                break;
            }
            case 6: {
                this.drawTailUpRightCorner(matrix4f, vertexConsumer);
                break;
            }
            case 7: {
                this.drawTailDownRightCorner(matrix4f, vertexConsumer);
                break;
            }
            case 2: {
                this.drawTailLeft(matrix4f, vertexConsumer);
                break;
            }
            case 3: {
                this.drawTailUpLeftCorner(matrix4f, vertexConsumer);
                break;
            }
            case 4: {
                this.drawTailDownLeftCorner(matrix4f, vertexConsumer);
            }
        }
        bufferSource.method_22993();
        poseStack.method_22909();
    }

    public class_241 getTailOffset(class_4184 camera) {
        class_243 entityPos = this.dialog.translateToRelative(this.dialog.getDialogPosition());
        class_243 dialogPos = this.dialog.translateToRelativeApplyOffset(this.dialog.getDialogPosition());
        class_243 toDialog = dialogPos.method_1020(entityPos);
        class_243 camRight = new class_243(camera.method_35689()).method_1021(-1.0);
        class_243 camUp = new class_243(camera.method_19336());
        float scale = this.dialog.getScale() * 0.025f;
        return new class_241((float)(toDialog.method_1026(camRight) / (double)scale), (float)(toDialog.method_1026(camUp) / (double)scale));
    }

    void drawTailTop(Matrix4f matrix4f, class_4588 vertexConsumer, float topRight, float topLeft) {
        vertexConsumer.method_22918(matrix4f, 0.0f, -this.dialog.getHeight() - this.height, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, -topRight, -this.dialog.getHeight(), 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, -topLeft, -this.dialog.getHeight(), 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, -topRight, -this.dialog.getHeight(), 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
    }

    void drawTailBottom(Matrix4f matrix4f, class_4588 vertexConsumer, float topRight, float topLeft) {
        vertexConsumer.method_22918(matrix4f, -topRight, 0.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, -topLeft, 0.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, 0.0f, this.height, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, -topRight, 0.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
    }

    void drawTailLeft(Matrix4f matrix4f, class_4588 vertexConsumer) {
        vertexConsumer.method_22918(matrix4f, -this.height, 0.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, 0.0f, this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
    }

    void drawTailRight(Matrix4f matrix4f, class_4588 vertexConsumer) {
        vertexConsumer.method_22918(matrix4f, this.height, 0.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, 0.0f, this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, 0.0f, this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
    }

    void drawTailUpRightCorner(Matrix4f matrix4f, class_4588 vertexConsumer) {
        vertexConsumer.method_22918(matrix4f, this.height / 2.0f, -4.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, -this.width, -this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, 0.0f, this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, this.height / 2.0f, -4.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
    }

    void drawTailDownRightCorner(Matrix4f matrix4f, class_4588 vertexConsumer) {
        vertexConsumer.method_22918(matrix4f, this.height / 2.0f, 4.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, -this.width, this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, this.height / 2.0f, 4.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
    }

    void drawTailUpLeftCorner(Matrix4f matrix4f, class_4588 vertexConsumer) {
        vertexConsumer.method_22918(matrix4f, -this.height / 2.0f, -4.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, 0.0f, this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, this.width, -this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, -this.height / 2.0f, -4.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
    }

    void drawTailDownLeftCorner(Matrix4f matrix4f, class_4588 vertexConsumer) {
        vertexConsumer.method_22918(matrix4f, -this.height / 2.0f, 4.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, this.width, this.width / 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, this.width, -this.width * 2.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, -this.height / 2.0f, 4.0f, 0.0f).method_39415(this.dialog.getBackgroundColor()).method_60803(0xF000F0);
    }

    static enum TailDirection {
        TOP,
        BOTTOM,
        LEFT,
        LEFT_UP_CORNER,
        LEFT_DOWN_CORNER,
        RIGHT,
        RIGHT_UP_CORNER,
        RIGHT_DOWN_CORNER;

    }
}

