/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story;

import com.bladecoder.ink.runtime.Story;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.hud.StoryDebugHud;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogEntityBobbing;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer2D;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import fr.loudo.narrativecraft.narrative.inkTag.InkTagHandlerException;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StorySave;
import fr.loudo.narrativecraft.options.NarrativeClientOption;
import fr.loudo.narrativecraft.options.NarrativeWorldOption;
import fr.loudo.narrativecraft.screens.components.CrashScreen;
import fr.loudo.narrativecraft.screens.credits.CreditScreen;
import fr.loudo.narrativecraft.screens.story.StoryChoicesScreen;
import fr.loudo.narrativecraft.util.InkUtil;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class StoryHandler {
    private final NarrativeWorldOption worldOption = NarrativeCraftMod.getInstance().getNarrativeWorldOption();
    private final NarrativeClientOption clientOption = NarrativeCraftMod.getInstance().getNarrativeClientOptions();
    private final class_310 minecraft = class_310.method_1551();
    public static final String DIALOG_REGEX = "^(\\w+)\\s*:\\s*(.+?)\\s*$";
    private final PlayerSession playerSession;
    private final StoryDebugHud storyDebugHud;
    private DialogData dialogData = new DialogData(DialogData.globalDialogData);
    private Story story;
    private String dialogText;
    private boolean loadScene;
    private boolean debugMode;
    private boolean firstLoad;
    private boolean hasError;

    public StoryHandler(PlayerSession playerSession) {
        this.playerSession = playerSession;
        Chapter firstChapter = NarrativeCraftMod.getInstance().getChapterManager().getChapterByIndex(1);
        playerSession.setChapter(firstChapter);
        playerSession.setScene(firstChapter.getSortedSceneList().getFirst());
        this.storyDebugHud = new StoryDebugHud(playerSession);
    }

    public StoryHandler(Chapter chapter, PlayerSession playerSession) {
        this.playerSession = playerSession;
        playerSession.setChapter(chapter);
        playerSession.setScene(chapter.getSortedSceneList().getFirst());
        this.storyDebugHud = new StoryDebugHud(playerSession);
    }

    public StoryHandler(Chapter chapter, Scene scene, PlayerSession playerSession) {
        this.playerSession = playerSession;
        playerSession.setChapter(chapter);
        playerSession.setScene(scene);
        this.loadScene = true;
        this.storyDebugHud = new StoryDebugHud(playerSession);
    }

    public boolean isRunning() {
        return this.story != null;
    }

    public boolean isFinished() {
        return !this.story.canContinue() && this.story.getCurrentChoices().isEmpty() && !this.story.hasError() && !this.hasError;
    }

    public void start() {
        if (this.playerSession.getController() != null) {
            this.playerSession.getController().stopSession(false);
        }
        this.playerSession.setStoryHandler(this);
        this.firstLoad = true;
        try {
            this.story = new Story(NarrativeCraftFile.storyContent());
            this.story.onError = (s, errorType) -> {
                NarrativeCraftMod.server.execute(this::stop);
                this.showCrash(new Exception(String.valueOf(errorType) + " " + s));
                this.hasError = true;
            };
            if (NarrativeCraftFile.saveExists() && !this.debugMode) {
                this.loadSave();
                if (!this.loadScene) {
                    this.firstLoad = false;
                    return;
                }
            }
            if (this.loadScene) {
                this.loadScene(this.playerSession.getScene());
            }
            this.next();
        }
        catch (Exception e) {
            this.stop();
            this.showCrash(e);
        }
    }

    public void stop() {
        this.playerSession.getInkTagHandler().stopAll();
        for (InkAction inkAction : this.playerSession.getInkActions()) {
            inkAction.stop();
        }
        this.playerSession.getInkActions().clear();
        for (Playback playback : this.playerSession.getPlaybackManager().getPlaybacks()) {
            playback.stop(true);
        }
        for (CharacterRuntime characterRuntime : this.playerSession.getCharacterRuntimes()) {
            if (characterRuntime.getEntity() == null || !characterRuntime.getEntity().method_5805()) continue;
            characterRuntime.getEntity().method_5650(class_1297.class_5529.field_26998);
        }
        AbstractController controller = this.playerSession.getController();
        if (controller != null) {
            controller.stopSession(false);
        }
        this.playerSession.setCurrentCamera(null);
        this.playerSession.getCharacterRuntimes().clear();
        this.playerSession.setDialogRenderer(null);
        this.playerSession.setStoryHandler(null);
        this.playerSession.getInkTagHandler().getTagsToExecute().clear();
    }

    public void stopAndFinishScreen() {
        this.stop();
        if (this.worldOption.showCreditsScreen && !this.debugMode) {
            CreditScreen creditScreen = new CreditScreen(this.playerSession, false, !this.worldOption.finishedStory);
            this.minecraft.execute(() -> this.minecraft.method_1507((class_437)creditScreen));
            this.worldOption.finishedStory = true;
            NarrativeCraftFile.updateWorldOptions(this.worldOption);
        }
    }

    public boolean characterInStory(CharacterStory characterStory) {
        for (CharacterRuntime characterRuntime : this.playerSession.getCharacterRuntimes()) {
            if (!characterRuntime.getCharacterStory().getName().equals(characterStory.getName())) continue;
            return true;
        }
        return false;
    }

    public CharacterRuntime getCharacterRuntimeFromCharacter(CharacterStory characterStory) {
        for (CharacterRuntime characterRuntime : this.playerSession.getCharacterRuntimes()) {
            if (!characterRuntime.getCharacterStory().getName().equals(characterStory.getName())) continue;
            return characterRuntime;
        }
        return null;
    }

    public void killCharacter(CharacterStory characterStory) {
        CharacterRuntime toRemove = null;
        for (CharacterRuntime characterRuntime : this.playerSession.getCharacterRuntimes()) {
            if (!characterRuntime.getCharacterStory().getName().equals(characterStory.getName()) || characterRuntime.getEntity() == null) continue;
            characterRuntime.getEntity().method_5650(class_1297.class_5529.field_26998);
            toRemove = characterRuntime;
        }
        this.playerSession.getCharacterRuntimes().remove(toRemove);
    }

    public void chooseChoiceAndNext(int choiceIndex) {
        try {
            this.story.chooseChoiceIndex(choiceIndex);
            this.playerSession.setDialogRenderer(null);
            this.next();
            if (this.dialogText.isEmpty() && !this.isFinished()) {
                throw new Exception("Empty dialog after a choice cannot be rendered!");
            }
        }
        catch (Exception e) {
            this.stop();
            NarrativeCraftMod.LOGGER.error("Can't choose the choice: ", (Throwable)e);
            Util.sendCrashMessage((class_1657)this.minecraft.field_1724, e);
        }
    }

    public void next() {
        try {
            if (this.story == null) {
                throw new Exception("Story is not initialized!");
            }
            DialogRenderer dialogRenderer = this.playerSession.getDialogRenderer();
            if (this.isFinished()) {
                if (dialogRenderer != null) {
                    dialogRenderer.setRunDialogStopped(this::stopAndFinishScreen);
                    dialogRenderer.stop();
                } else {
                    this.stopAndFinishScreen();
                }
                return;
            }
            if (!this.story.getCurrentChoices().isEmpty()) {
                this.handleChoices();
                return;
            }
            this.dialogText = this.story.Continue().replace("\n", "");
            if (this.story.hasError() || this.hasError) {
                return;
            }
            if (this.firstLoad) {
                this.save(false);
                this.firstLoad = false;
            }
            this.playerSession.getInkTagHandler().getTagsToExecute().addAll(this.story.getCurrentTags());
            if (this.isTransitioning() && dialogRenderer != null) {
                dialogRenderer.stop();
                return;
            }
            if (this.dialogText.isEmpty() && !this.story.getCurrentChoices().isEmpty() && dialogRenderer != null) {
                this.playerSession.getInkTagHandler().setRun(() -> {
                    this.playerSession.getInkTagHandler().setRun(null);
                    this.showChoices();
                });
                dialogRenderer.stop();
                return;
            }
            if (dialogRenderer != null && this.isFinished() && this.dialogText.isEmpty()) {
                dialogRenderer.stop();
                return;
            }
            String currentStitch = this.story.getState().getCurrentStitch();
            if (currentStitch != null && !currentStitch.equalsIgnoreCase(this.playerSession.getStitch()) && dialogRenderer != null) {
                this.playerSession.setStitch(this.story.getState().getCurrentStitch());
                dialogRenderer.stop();
                return;
            }
            if (dialogRenderer == null || this.sameCharacterTalking(this.dialogText)) {
                this.playerSession.getInkTagHandler().execute();
            } else {
                dialogRenderer.stop();
            }
            this.playerSession.setStitch(this.story.getState().getCurrentStitch());
            this.playerSession.clearKilledCharacters();
            this.playerSession.clearPlaybacksNotPlaying();
        }
        catch (Exception e) {
            this.stop();
            this.showCrash(e);
        }
    }

    public void showCurrentDialog() {
        try {
            this.showDialog(this.dialogText);
        }
        catch (Exception e) {
            this.stop();
            this.showCrash(e);
        }
    }

    public Matcher getDialogMatcher(String dialog) {
        Pattern pattern = Pattern.compile(DIALOG_REGEX);
        return pattern.matcher(dialog);
    }

    private void loadSave() throws Exception {
        StorySave save = NarrativeCraftFile.saveContent();
        if (save == null) {
            throw new Exception("Chapter or scene cannot be found in save file");
        }
        this.story.getState().loadJson(save.getSaveData());
        if (this.loadScene) {
            return;
        }
        this.playerSession.setChapter(save.getChapter());
        this.playerSession.setScene(save.getScene());
        ArrayList tags = new ArrayList(this.story.getCurrentTags());
        int subListId = 0;
        for (int i = 0; i < tags.size(); ++i) {
            if (!"on enter".equals(tags.get(i))) continue;
            subListId = i + 1;
            break;
        }
        List newTags = new ArrayList();
        if (subListId <= tags.size()) {
            newTags.addAll(tags.subList(subListId, tags.size()));
        }
        if (!newTags.isEmpty() && ((String)newTags.getFirst()).equalsIgnoreCase("save")) {
            newTags = newTags.subList(1, newTags.size());
        }
        newTags.addAll(save.getTagsRunning());
        this.story.getCurrentTags().clear();
        this.story.getCurrentTags().addAll(newTags);
        this.playerSession.getInkTagHandler().getTagsToExecute().addAll(this.story.getCurrentTags());
        for (CharacterStoryData characterStoryData : save.getCharacterStoryDataList()) {
            characterStoryData.spawn(this.playerSession.getPlayer().method_37908(), Environment.PRODUCTION);
            this.playerSession.getCharacterRuntimes().add(characterStoryData.getCharacterRuntime());
        }
        this.dialogData = save.getDialogData();
        this.dialogText = this.story.getCurrentText().replace("\n", "");
        this.playerSession.getInkTagHandler().execute();
        if (!this.story.getCurrentChoices().isEmpty()) {
            this.handleChoices();
        }
    }

    private void loadScene(Scene scene) throws Exception {
        try {
            this.story.choosePathString(scene.knotName());
        }
        catch (Exception e) {
            this.story.choosePathString(NarrativeCraftMod.getInstance().getChapterManager().getChapters().getFirst().getSortedSceneList().getLast().knotName());
        }
    }

    private void handleChoices() {
        DialogRenderer dialogRenderer = this.playerSession.getDialogRenderer();
        if (dialogRenderer != null) {
            dialogRenderer.stop();
            dialogRenderer.setRunDialogStopped(this::showChoices);
        } else {
            this.showChoices();
        }
    }

    public void showChoices() {
        this.playerSession.setDialogRenderer(null);
        StoryChoicesScreen choicesScreen = new StoryChoicesScreen(this.playerSession, true);
        this.minecraft.execute(() -> this.minecraft.method_1507((class_437)choicesScreen));
    }

    public void showCrash(Exception exception) {
        if (this.debugMode) {
            NarrativeCraftMod.LOGGER.error("Error occurred on the story: ", (Throwable)exception);
            Util.sendCrashMessage((class_1657)this.playerSession.getPlayer(), exception);
        } else {
            CrashScreen screen = new CrashScreen(this.playerSession, exception.getMessage());
            this.minecraft.execute(() -> this.minecraft.method_1507((class_437)screen));
        }
    }

    public void save(boolean showLogo) {
        try {
            if (!this.debugMode) {
                StorySave save = new StorySave(this.playerSession);
                NarrativeCraftFile.writeSave(save);
            }
            if (showLogo) {
                this.playerSession.getStorySaveIconGui().showSave(this.debugMode);
            }
        }
        catch (Exception e) {
            this.stop();
            this.showCrash(e);
        }
    }

    public boolean isChangingScene() {
        String currentKnot = this.story.getState().getCurrentKnot();
        return currentKnot != null && !currentKnot.equalsIgnoreCase(this.playerSession.getScene().knotName());
    }

    private void showDialog(String dialog) throws Exception {
        if (dialog == null || ((String)dialog).isEmpty()) {
            return;
        }
        Matcher matcher = this.getDialogMatcher((String)dialog);
        CharacterStory characterStory = null;
        if (matcher.matches()) {
            String characterName = matcher.group(1).trim();
            characterStory = NarrativeCraftMod.getInstance().getCharacterManager().getCharacterByName(characterName);
            if (characterStory == null) {
                characterStory = this.playerSession.getScene().getNpcByName(characterName);
            }
            if (characterStory == null) {
                throw new Exception("Character " + characterName + " was not found.");
            }
            if (!this.characterInStory(characterStory)) {
                throw new Exception("Character " + characterName + " is not in the story, can't render the dialog.");
            }
            dialog = matcher.group(2).trim() + "\n";
        }
        DialogRenderer newDialogRenderer = this.getDialogRenderer((String)dialog, characterStory);
        DialogRenderer dialogRenderer = this.playerSession.getDialogRenderer();
        if (dialogRenderer == null || newDialogRenderer.getClass() != dialogRenderer.getClass()) {
            this.playerSession.setDialogRenderer(newDialogRenderer);
            newDialogRenderer.setRunDialogStopped(() -> {
                this.playerSession.setDialogRenderer(null);
                try {
                    if (this.playerSession.getInkTagHandler().getTagsToExecute().isEmpty()) {
                        this.showCurrentDialog();
                    } else {
                        this.playerSession.getInkTagHandler().execute();
                    }
                }
                catch (Exception e) {
                    this.stop();
                    if (!this.debugMode && e instanceof InkTagHandlerException) {
                        CrashScreen screen = new CrashScreen(this.playerSession, e.getMessage());
                        this.minecraft.execute(() -> this.minecraft.method_1507((class_437)screen));
                    }
                    Util.sendCrashMessage((class_1657)this.playerSession.getPlayer(), e);
                }
            });
            newDialogRenderer.setRunDialogAutoSkipped(this::next);
            newDialogRenderer.start();
        } else {
            this.configureAutoSkip(dialogRenderer, (String)dialog);
            dialogRenderer.autoSkipAt(this.dialogData.getAutoSkipSeconds());
            dialogRenderer.setText((String)dialog);
            dialogRenderer.update();
        }
    }

    private boolean sameCharacterTalking(String dialog) {
        DialogRenderer dialogRenderer = this.playerSession.getDialogRenderer();
        Matcher matcher = this.getDialogMatcher(dialog);
        if (dialog.isEmpty()) {
            return false;
        }
        if (dialogRenderer instanceof DialogRenderer2D && !matcher.matches()) {
            return true;
        }
        if (!(dialogRenderer instanceof DialogRenderer3D)) {
            return false;
        }
        String characterName = "";
        if (matcher.matches()) {
            characterName = matcher.group(1).trim();
        }
        return ((DialogRenderer3D)dialogRenderer).getCharacterRuntime().getCharacterStory().getName().equalsIgnoreCase(characterName);
    }

    private DialogRenderer getDialogRenderer(String dialog, CharacterStory characterStory) {
        DialogRenderer dialogRenderer;
        if (characterStory != null) {
            CharacterRuntime characterRuntime = this.playerSession.getCharacterRuntimeByCharacter(characterStory);
            dialogRenderer = new DialogRenderer3D(dialog, characterStory.getName(), this.dialogData, characterRuntime);
            DialogRenderer3D dialogRenderer3D = (DialogRenderer3D)dialogRenderer;
            dialogRenderer3D.setDialogEntityBobbing(new DialogEntityBobbing(dialogRenderer3D, this.dialogData.getNoiseShakeSpeed(), this.dialogData.getNoiseShakeStrength()));
        } else {
            dialogRenderer = new DialogRenderer2D(dialog, 350, 400, 90, 30, this.dialogData);
        }
        this.configureAutoSkip(dialogRenderer, dialog);
        dialogRenderer.autoSkipAt(this.dialogData.getAutoSkipSeconds());
        dialogRenderer.setNoSkip(this.dialogData.isNoSkip());
        return dialogRenderer;
    }

    private void configureAutoSkip(DialogRenderer dialogRenderer, String dialog) {
        dialogRenderer.stopAutoSkip();
        if (this.clientOption.autoSkip) {
            String[] words = dialog.trim().split("\\s+");
            int wordCount = words.length;
            double readingSpeed = 3.0;
            int autoSkipTime = (int)Math.ceil((double)wordCount / readingSpeed);
            autoSkipTime = Math.max(autoSkipTime, 2);
            dialogRenderer.autoSkipAt(autoSkipTime);
        }
    }

    private boolean isTransitioning() {
        if (this.story.getState().getCurrentKnot() == null) {
            return false;
        }
        return !this.story.getState().getCurrentKnot().equals(this.playerSession.getScene().knotName()) && this.story.getState().getCurrentKnot().matches(InkUtil.SCENE_KNOT_PATTERN.pattern());
    }

    public DialogData getDialogData() {
        return this.dialogData;
    }

    public void setDialogData(DialogData dialogData) {
        this.dialogData = dialogData;
    }

    public Story getStory() {
        return this.story;
    }

    public String getDialogText() {
        return this.dialogText;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public StoryDebugHud getStoryDebugHud() {
        return this.storyDebugHud;
    }

    public PlayerSession getPlayerSession() {
        return this.playerSession;
    }
}

