/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.mixin.accessor.FontAccessor;
import fr.loudo.narrativecraft.mixin.accessor.PlayerAccessor;
import fr.loudo.narrativecraft.mixin.accessor.PlayerListAccessor;
import fr.loudo.narrativecraft.mixin.invoker.FontInvoker;
import fr.loudo.narrativecraft.mixin.invoker.PauseScreenInvoker;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.platform.Services;
import fr.loudo.narrativecraft.util.FakePlayer;
import fr.loudo.narrativecraft.util.Translation;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2703;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_377;
import net.minecraft.class_379;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class Util {
    public static final String REGEX_FLOAT = "^-?\\d*(\\.\\d*)?$";
    public static final String REGEX_FLOAT_ONLY_POSITIVE = "^\\d*(\\.\\d*)?$";
    public static final String REGEX_INT = "^\\d*$";
    public static final String REGEX_NO_SPECIAL_CHARACTERS = "[a-zA-Z0-9 _-]*";

    public static String snakeCase(String value) {
        return String.join((CharSequence)"_", value.toLowerCase().split(" "));
    }

    public static void sendCrashMessage(class_1657 player, Exception exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = "";
        }
        String finalMessage = message;
        player.method_7353((class_2561)Translation.message("crash.global-message", new Object[0]).method_27692(class_124.field_1061).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)finalMessage)))), false);
        NarrativeCraftMod.LOGGER.error("Unexpected error occurred on NarrativeCraft: ", (Throwable)exception);
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            player.method_7353((class_2561)class_2561.method_43470((String)("-- " + finalMessage)).method_27692(class_124.field_1061), false);
        }
    }

    public static class_2487 tagFromIdAndComponents(class_1792 item, String data) {
        class_2487 tag = new class_2487();
        try {
            tag.method_10566("components", (class_2520)Util.nbtFromString(data));
        }
        catch (CommandSyntaxException e) {
            return null;
        }
        tag.method_10566("id", (class_2520)class_2519.method_23256((String)class_7923.field_41178.method_10221((Object)item).toString()));
        tag.method_10566("count", (class_2520)class_2497.method_23247((int)1));
        return tag;
    }

    public static class_2487 nbtFromString(String nbtString) throws CommandSyntaxException {
        return class_2522.method_10718((String)nbtString);
    }

    public static class_2680 getBlockStateFromData(String data, class_5455 registry) {
        try {
            class_2487 compoundTag = Util.nbtFromString(data);
            return class_2512.method_10681((class_7871)registry.method_46762(class_7924.field_41254), (class_2487)compoundTag);
        }
        catch (CommandSyntaxException ignored) {
            return null;
        }
    }

    public static class_2520 getItemTag(class_1799 itemStack, class_5455 registryAccess) {
        class_2487 tag;
        class_6903 ops = registryAccess.method_57093((DynamicOps)class_2509.field_11560);
        try {
            tag = (class_2520)class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)itemStack).getOrThrow();
        }
        catch (Exception exception) {
            tag = new class_2487();
        }
        return tag;
    }

    public static class_1799 generateItemStackFromNBT(class_2487 compoundTag, class_5455 registryAccess) {
        class_6903 ops = registryAccess.method_57093((DynamicOps)class_2509.field_11560);
        if (compoundTag == null) {
            return class_1799.field_8037;
        }
        try {
            return (class_1799)class_1799.field_24671.parse((DynamicOps)ops, (Object)compoundTag).getOrThrow();
        }
        catch (Exception e) {
            return class_1799.field_8037;
        }
    }

    public static void addFakePlayerUUID(FakePlayer fakePlayer) {
        if (NarrativeCraftMod.server == null) {
            return;
        }
        ((PlayerListAccessor)NarrativeCraftMod.server.method_3760()).getPlayersByUUID().put(fakePlayer.method_5667(), fakePlayer);
    }

    public static void removeFakePlayerUUID(FakePlayer fakePlayer) {
        if (NarrativeCraftMod.server == null) {
            return;
        }
        ((PlayerListAccessor)NarrativeCraftMod.server.method_3760()).getPlayersByUUID().remove(fakePlayer.method_5667());
    }

    public static boolean isSameEntity(class_1297 entity1, class_1297 entity2) {
        if (entity1 == null || entity2 == null) {
            return false;
        }
        return entity1.method_5667().equals(entity2.method_5667());
    }

    public static boolean isSamePlayer(class_3222 player1, class_3222 player2) {
        if (player1 == null || player2 == null) {
            return false;
        }
        return player1.method_5667().equals(player2.method_5667());
    }

    public static class_1297 createEntityFromKey(class_1299<?> entityType, class_3218 serverLevel) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10582("id", class_7923.field_41177.method_10221(entityType).toString());
        Optional entity = class_1299.method_5892((class_2487)compoundTag, (class_1937)serverLevel);
        return entity.orElse(null);
    }

    public static class_1309 createEntityFromCharacter(CharacterStory characterStory, class_1937 level) {
        FakePlayer entity;
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), characterStory.getName());
        if (class_7923.field_41177.method_10206(characterStory.getEntityType()) == class_7923.field_41177.method_10206((Object)class_1299.field_6097)) {
            entity = new FakePlayer((class_3218)level, gameProfile);
            entity.method_5841().method_12778(PlayerAccessor.getDATA_PLAYER_MODE_CUSTOMISATION(), (Object)127);
        } else {
            entity = (class_1309)Util.createEntityFromKey(characterStory.getEntityType(), (class_3218)level);
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.method_5977(true);
            }
        }
        if (entity instanceof FakePlayer) {
            FakePlayer fakePlayer = entity;
            ((PlayerListAccessor)level.method_8503().method_3760()).getPlayersByUUID().put(fakePlayer.method_5667(), fakePlayer);
            level.method_8503().method_3760().method_14581((class_2596)new class_2703(class_2703.class_5893.field_29136, (class_3222)fakePlayer));
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_18213((class_3222)fakePlayer);
            }
            Util.addFakePlayerUUID(fakePlayer);
        } else {
            level.method_8649((class_1297)entity);
        }
        return entity;
    }

    public static void disconnectPlayer() {
        class_433 pauseScreen = new class_433(false);
        class_310.method_1551().method_1507((class_437)pauseScreen);
        ((PauseScreenInvoker)pauseScreen).callOnDisconnect();
    }

    public static float getLetterWidth(int letterCode, class_310 minecraft) {
        class_2583 style = class_2583.field_24360;
        class_377 fontset = ((FontInvoker)minecraft.field_1772).callGetFontSet(style.method_27708());
        class_379 glyph = fontset.method_2011(letterCode, ((FontAccessor)minecraft.field_1772).getFilterFishyGlyphs());
        boolean bold = style.method_10984();
        return glyph.method_16798(bold);
    }

    public static int[] getImageResolution(class_2960 resourceLocation) {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        Optional resource = resourceManager.method_14486(resourceLocation);
        if (resource.isPresent()) {
            int[] nArray;
            block9: {
                InputStream stream = ((class_3298)resource.get()).method_14482();
                try {
                    BufferedImage image = ImageIO.read(stream);
                    int width = image.getWidth();
                    int height = image.getHeight();
                    nArray = new int[]{width, height};
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                stream.close();
            }
            return nArray;
        }
        return null;
    }

    public static int getDynamicHeight(int[] resolution, int newWidth) {
        float ratio = (float)resolution[1] / (float)resolution[0];
        return Math.round(ratio * (float)newWidth);
    }

    public static boolean resourceExists(class_2960 resourceLocation) {
        return class_310.method_1551().method_1478().method_14486(resourceLocation).isPresent();
    }
}

