/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.narrative.story.StoryValidation;
import fr.loudo.narrativecraft.util.ErrorLine;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class StoryCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nc").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"story").then(Commands.literal((String)"validate").executes(StoryCommand::validateStory))).then(Commands.literal((String)"play").then(Commands.argument((String)"chapter_index", (ArgumentType)IntegerArgumentType.integer()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getChapterSuggestions()).then(Commands.argument((String)"scene_name", (ArgumentType)StringArgumentType.string()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getSceneSuggestionsByChapter()).then(Commands.argument((String)"debug", (ArgumentType)BoolArgumentType.bool()).executes(context -> StoryCommand.playStoryChapterStory((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"chapter_index"), StringArgumentType.getString((CommandContext)context, (String)"scene_name"), BoolArgumentType.getBool((CommandContext)context, (String)"debug")))))))).then(Commands.literal((String)"stop").executes(StoryCommand::stopStory))));
    }

    private static int validateStory(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        player.sendSystemMessage((Component)Component.empty());
        player.sendSystemMessage((Component)Translation.message("validation.validating", new Object[0]).withStyle(ChatFormatting.YELLOW));
        try {
            List<ErrorLine> results = StoryValidation.validate();
            List<ErrorLine> warnLines = results.stream().filter(ErrorLine::isWarn).toList();
            List<ErrorLine> errorLines = results.stream().filter(errorLine -> !errorLine.isWarn()).toList();
            if (errorLines.isEmpty() && warnLines.isEmpty()) {
                player.sendSystemMessage((Component)Translation.message("validation.validated", new Object[0]).withStyle(ChatFormatting.GREEN));
                player.sendSystemMessage((Component)Component.empty());
                return 1;
            }
            for (ErrorLine errorLine2 : results) {
                player.sendSystemMessage(errorLine2.toMessage());
            }
            if (!errorLines.isEmpty()) {
                player.sendSystemMessage((Component)Translation.message("validation.found_errors", Component.literal((String)String.valueOf(errorLines.size())).withStyle(ChatFormatting.GOLD)).withStyle(ChatFormatting.RED));
                player.sendSystemMessage((Component)Component.empty());
            }
            if (!warnLines.isEmpty()) {
                player.sendSystemMessage((Component)Translation.message("validation.found_warns", Component.literal((String)String.valueOf(warnLines.size())).withStyle(ChatFormatting.GOLD)).withStyle(ChatFormatting.YELLOW));
            }
            return errorLines.isEmpty() ? 1 : 0;
        }
        catch (Exception e) {
            Util.sendCrashMessage((Player)player, e);
            player.sendSystemMessage((Component)Component.empty());
            return 1;
        }
    }

    private static int playStoryChapterStory(CommandContext<CommandSourceStack> context, int chapterIndex, String sceneName, boolean debug) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        if (!NarrativeCraftFile.getStoryFile().exists()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("story.no_exists", new Object[0]));
            return 0;
        }
        Chapter chapter = NarrativeCraftMod.getInstance().getChapterManager().getChapterByIndex(chapterIndex);
        if (chapter == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("chapter.no_exists", chapterIndex));
            return 0;
        }
        Scene scene = chapter.getSceneByName(sceneName);
        if (scene == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("scene.no_exists", sceneName, chapterIndex));
            return 0;
        }
        if (StoryCommand.validateStory(context) == 0) {
            return 0;
        }
        if (playerSession.getStoryHandler() != null) {
            playerSession.getStoryHandler().stop();
        }
        StoryHandler storyHandler = new StoryHandler(chapter, scene, playerSession);
        storyHandler.setDebugMode(debug);
        storyHandler.start();
        return 1;
    }

    private static int stopStory(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).hasPermission(2)) {
            return 0;
        }
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).getPlayer());
        if (playerSession == null) {
            return 0;
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Translation.message("story.not_playing", new Object[0]));
            return 0;
        }
        storyHandler.stop();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.message("story.stopped", new Object[0]), false);
        return 1;
    }
}

