/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractController {
    protected final Environment environment;
    protected final PlayerSession playerSession;
    protected String hudMessage;

    public AbstractController(Environment environment, Player player) {
        this.environment = environment;
        this.playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer(player);
    }

    public abstract void startSession();

    public abstract void stopSession(boolean var1);

    public abstract Screen getControllerScreen();

    protected void stopCurrentSession() {
        AbstractController controller = this.playerSession.getController();
        if (controller == null) {
            return;
        }
        controller.stopSession(false);
    }

    public void renderHUDInfo(GuiGraphics guiGraphics) {
        if (this.playerSession.getCurrentCamera() != null || this.environment != Environment.DEVELOPMENT) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        int width = minecraft.getWindow().getGuiScaledWidth();
        guiGraphics.drawString(font, this.hudMessage, width / 2 - font.width(this.hudMessage) / 2, 10, ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public PlayerSession getPlayerSession() {
        return this.playerSession;
    }
}

