/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.cameraAngle;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframesBase;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.CameraAngle;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cameraAngle.CameraAngleKeyframe;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.screens.controller.cameraAngle.CameraAngleControllerScreen;
import fr.loudo.narrativecraft.screens.controller.cameraAngle.CameraAngleOptionsScreen;
import fr.loudo.narrativecraft.util.Translation;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CameraAngleController
extends AbstractKeyframesBase<CameraAngleKeyframe> {
    private final CameraAngle cameraAngle;

    public CameraAngleController(Environment environment, Player player, CameraAngle cameraAngle) {
        super(environment, player);
        this.cameraAngle = cameraAngle;
        this.hudMessage = Translation.message("controller.camera_angle.hud", new Object[0]).getString();
        this.characterStoryDataList.addAll(cameraAngle.getCharacterStoryDataList());
        this.keyframes.addAll(cameraAngle.getCameraAngleKeyframes());
    }

    public CameraAngleKeyframe createKeyframe(String name) {
        CameraAngleKeyframe keyframe = new CameraAngleKeyframe(this.keyframesCounter.incrementAndGet(), this.getKeyframeLocationFromPlayer(), name);
        keyframe.showKeyframe(this.playerSession.getPlayer());
        this.keyframes.add(keyframe);
        return keyframe;
    }

    public CameraAngleKeyframe getKeyframeByName(String name) {
        for (CameraAngleKeyframe keyframe : this.keyframes) {
            if (!keyframe.getName().equalsIgnoreCase(name)) continue;
            return keyframe;
        }
        return null;
    }

    @Override
    public Screen keyframeOptionScreen(Keyframe keyframe, boolean hide) {
        return new CameraAngleOptionsScreen((CameraAngleKeyframe)keyframe, this, this.playerSession, hide);
    }

    @Override
    public void startSession() {
        this.stopCurrentSession();
        this.playerSession.setController(this);
        for (CharacterStoryData characterStoryData : this.characterStoryDataList) {
            characterStoryData.spawn((Level)this.playerSession.getPlayer().level(), this.environment);
            this.playerSession.getCharacterRuntimes().add(characterStoryData.getCharacterRuntime());
        }
        if (this.environment != Environment.DEVELOPMENT) {
            return;
        }
        Location location = null;
        if (!this.characterStoryDataList.isEmpty()) {
            location = ((CharacterStoryData)this.characterStoryDataList.getFirst()).getLocation();
        } else if (!this.keyframes.isEmpty()) {
            this.keyframesCounter.set(((CameraAngleKeyframe)this.keyframes.getLast()).getId());
            location = ((CameraAngleKeyframe)this.keyframes.getFirst()).getKeyframeLocation().asLocation();
        }
        if (location != null) {
            this.playerSession.getPlayer().teleportTo(location.x(), location.y(), location.z());
        }
        for (CameraAngleKeyframe cameraAngleKeyframe : this.keyframes) {
            cameraAngleKeyframe.showKeyframe(this.playerSession.getPlayer());
        }
    }

    @Override
    public void stopSession(boolean save) {
        for (CharacterStoryData characterStoryData : this.characterStoryDataList) {
            characterStoryData.kill();
            this.playerSession.getCharacterRuntimes().remove(characterStoryData.getCharacterRuntime());
        }
        this.playerSession.setController(null);
        Minecraft.getInstance().options.hideGui = false;
        if (this.environment != Environment.DEVELOPMENT) {
            return;
        }
        for (CameraAngleKeyframe cameraAngleKeyframe : this.keyframes) {
            cameraAngleKeyframe.hideKeyframe(this.playerSession.getPlayer());
        }
        if (save) {
            List<CameraAngleKeyframe> oldCameraAngles = this.cameraAngle.getCameraAngleKeyframes();
            List<CharacterStoryData> oldCharacterStoryData = this.cameraAngle.getCharacterStoryDataList();
            this.cameraAngle.getCameraAngleKeyframes().clear();
            this.cameraAngle.getCharacterStoryDataList().clear();
            try {
                this.cameraAngle.getCameraAngleKeyframes().addAll(this.keyframes);
                this.cameraAngle.getCharacterStoryDataList().addAll(this.characterStoryDataList);
                NarrativeCraftFile.updateCameraAngles(this.cameraAngle.getScene());
                for (CharacterStoryData characterStoryData : this.cameraAngle.getCharacterStoryDataList()) {
                    characterStoryData.setSkinName(characterStoryData.getCharacterRuntime().getSkinName());
                }
                this.playerSession.getPlayer().sendSystemMessage((Component)Translation.message("controller.saved", new Object[0]));
            }
            catch (IOException e) {
                this.cameraAngle.getCameraAngleKeyframes().addAll(oldCameraAngles);
                this.cameraAngle.getCharacterStoryDataList().addAll(oldCharacterStoryData);
                for (CharacterStoryData characterStoryData : this.cameraAngle.getCharacterStoryDataList()) {
                    characterStoryData.setSkinName(characterStoryData.getCharacterRuntime().getOldSkinName());
                }
                this.playerSession.getPlayer().sendSystemMessage((Component)Translation.message("crash.global-message", new Object[0]));
                NarrativeCraftMod.LOGGER.error("Impossible to save the camera angle: ", (Throwable)e);
            }
        } else {
            for (CharacterStoryData characterStoryData : this.cameraAngle.getCharacterStoryDataList()) {
                characterStoryData.setSkinName(characterStoryData.getCharacterRuntime().getOldSkinName());
            }
        }
    }

    @Override
    public Screen getControllerScreen() {
        return new CameraAngleControllerScreen(this);
    }

    public CameraAngle getCameraAngle() {
        return this.cameraAngle;
    }

    public List<CharacterStory> getCharacterStories() {
        return this.characterStoryDataList.stream().map(CharacterStoryData::getCharacterStory).toList();
    }
}

