/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.inkAction.FadeInkAction;
import fr.loudo.narrativecraft.screens.controller.cutscene.CutsceneKeyframeOptionScreen;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.MathHelper;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class CutscenePlayback {
    private final CutsceneController cutsceneController;
    private final PlayerSession playerSession;
    private final Runnable onCutsceneEnd;
    private CutsceneKeyframe keyframeA;
    private CutsceneKeyframe keyframeB;
    private CutsceneKeyframeGroup currentKeyframeGroup;
    private int segmentTick;
    private int totalTick;
    private boolean isPlaying;

    public CutscenePlayback(CutsceneController cutsceneController, Runnable onCutsceneEnd) {
        this.cutsceneController = cutsceneController;
        this.playerSession = cutsceneController.getPlayerSession();
        this.onCutsceneEnd = onCutsceneEnd;
    }

    public void setupAndPlay(CutsceneKeyframe keyframeA, CutsceneKeyframe keyframeB) {
        this.keyframeA = keyframeA;
        this.keyframeB = keyframeB;
        this.currentKeyframeGroup = (CutsceneKeyframeGroup)this.cutsceneController.getKeyframeGroupOfKeyframe(keyframeA);
        this.cutsceneController.setPlaying(true);
        this.segmentTick = 0;
        this.totalTick = keyframeA.getTick();
        Minecraft.getInstance().options.hideGui = true;
        this.play();
    }

    public void play() {
        this.isPlaying = true;
    }

    public void skip() {
        CutsceneKeyframe lastKeyframe = (CutsceneKeyframe)((CutsceneKeyframeGroup)this.cutsceneController.getKeyframeGroups().getLast()).getKeyframes().getLast();
        int lastTick = lastKeyframe.getTick() + lastKeyframe.getTransitionDelayTick();
        NarrativeCraftMod.server.execute(() -> this.cutsceneController.changeTimePosition(lastTick - 1, false));
        if (this.cutsceneController.getEnvironment() == Environment.PRODUCTION) {
            this.playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof FadeInkAction);
        }
    }

    public void stop() {
        this.isPlaying = false;
        if (this.cutsceneController.getEnvironment() == Environment.DEVELOPMENT) {
            for (InkAction inkAction : this.playerSession.getInkActions()) {
                inkAction.stop();
            }
            this.playerSession.getInkActions().clear();
        }
    }

    public void tick() {
        if (!this.isPlaying) {
            return;
        }
        if (Minecraft.getInstance().options.keyShift.isDown() && this.cutsceneController.getEnvironment() == Environment.DEVELOPMENT) {
            this.stop();
            this.playerSession.setCurrentCamera(this.keyframeA.getKeyframeLocation());
            Minecraft.getInstance().setScreen((Screen)new CutsceneKeyframeOptionScreen(this.keyframeA, this.playerSession, false));
            this.cutsceneController.changeTimePosition(this.keyframeA.getTick(), true);
            this.cutsceneController.setPlaying(false);
        }
        ++this.segmentTick;
        if (this.segmentTick >= this.keyframeA.getStartDelayTick()) {
            ++this.totalTick;
        }
    }

    public void cameraInterpolation(double partialTick) {
        if (!this.isPlaying) {
            return;
        }
        if (this.segmentTick < this.keyframeA.getStartDelayTick()) {
            this.playerSession.setCurrentCamera(this.keyframeA.getKeyframeLocation());
            return;
        }
        double totalDelta = Math.clamp(((double)this.segmentTick + partialTick - (double)this.keyframeA.getStartDelayTick()) / (double)this.keyframeB.getPathTick(), 0.0, 1.0);
        if (this.keyframeB.getEasing() != Easing.SMOOTH || this.currentKeyframeGroup.getKeyframes().size() < 2) {
            totalDelta = this.keyframeB.getEasing().interpolate(totalDelta);
            this.playerSession.setCurrentCamera(this.interpolate(totalDelta / this.keyframeB.getSpeed(), this.keyframeA.getKeyframeLocation(), this.keyframeB.getKeyframeLocation()));
        } else {
            KeyframeLocation location = this.interpolateByCatmull(partialTick);
            this.playerSession.setCurrentCamera(location);
        }
        double extraDelay = 0.0;
        if (this.currentKeyframeGroup.isLastKeyframe(this.keyframeB)) {
            extraDelay += (double)this.keyframeB.getTransitionDelayTick();
        }
        if (totalDelta >= 1.0 && (double)this.segmentTick >= (double)(this.keyframeB.getPathTick() + this.keyframeA.getStartDelayTick()) + extraDelay) {
            if (this.cutsceneController.isLastKeyframe(this.keyframeB)) {
                this.onEnd();
            } else {
                this.pickNextKeyframes();
            }
        }
    }

    private KeyframeLocation interpolateByCatmull(double partialTick) {
        CutsceneKeyframe keyframe;
        List keyframes = this.currentKeyframeGroup.getKeyframes();
        if (keyframes.size() < 2) {
            return ((CutsceneKeyframe)keyframes.getLast()).getKeyframeLocation();
        }
        int startIndex = 0;
        Iterator iterator = keyframes.iterator();
        while (iterator.hasNext() && (keyframe = (CutsceneKeyframe)iterator.next()).getId() != this.keyframeA.getId()) {
            ++startIndex;
        }
        double elapsedTick = (double)this.totalTick + partialTick - (double)this.keyframeA.getTick();
        int accumulatedTick = 0;
        for (int i = startIndex; i < keyframes.size() - 1; ++i) {
            CutsceneKeyframe k1 = (CutsceneKeyframe)keyframes.get(i);
            CutsceneKeyframe k2 = (CutsceneKeyframe)keyframes.get(i + 1);
            int segmentDuration = (int)((double)k2.getPathTick() / k2.getSpeed());
            if (elapsedTick < (double)(accumulatedTick + segmentDuration)) {
                double t = (elapsedTick - (double)accumulatedTick) / (double)segmentDuration;
                CutsceneKeyframe p0 = (CutsceneKeyframe)keyframes.get(Math.max(i - 1, 0));
                CutsceneKeyframe p1 = k1;
                CutsceneKeyframe p2 = k2;
                CutsceneKeyframe p3 = (CutsceneKeyframe)keyframes.get(Math.min(i + 2, keyframes.size() - 1));
                return this.catmullRom(p0.getKeyframeLocation(), p1.getKeyframeLocation(), p2.getKeyframeLocation(), p3.getKeyframeLocation(), t);
            }
            accumulatedTick += segmentDuration;
        }
        return ((CutsceneKeyframe)keyframes.getLast()).getKeyframeLocation();
    }

    private KeyframeLocation catmullRom(KeyframeLocation p0, KeyframeLocation p1, KeyframeLocation p2, KeyframeLocation p3, double t) {
        double x = MathHelper.catmullRom((float)p0.getX(), (float)p1.getX(), (float)p2.getX(), (float)p3.getX(), (float)t);
        double y = MathHelper.catmullRom((float)p0.getY(), (float)p1.getY(), (float)p2.getY(), (float)p3.getY(), (float)t);
        double z = MathHelper.catmullRom((float)p0.getZ(), (float)p1.getZ(), (float)p2.getZ(), (float)p3.getZ(), (float)t);
        float pitch = MathHelper.catmullRom(p0.getPitch(), p1.getPitch(), p2.getPitch(), p3.getPitch(), (float)t);
        float yaw = MathHelper.catmullRom(Mth.wrapDegrees((float)p0.getYaw()), Mth.wrapDegrees((float)p1.getYaw()), Mth.wrapDegrees((float)p2.getYaw()), Mth.wrapDegrees((float)p3.getYaw()), (float)t);
        float fov = MathHelper.catmullRom(p0.getFov(), p1.getFov(), p2.getFov(), p3.getFov(), (float)t);
        float roll = MathHelper.catmullRom(Mth.wrapDegrees((float)p0.getRoll()), Mth.wrapDegrees((float)p1.getRoll()), Mth.wrapDegrees((float)p2.getRoll()), Mth.wrapDegrees((float)p3.getRoll()), (float)t);
        return new KeyframeLocation(x, y, z, pitch, yaw, roll, fov);
    }

    private void onEnd() {
        this.stop();
        this.playerSession.setCurrentCamera(this.keyframeB.getKeyframeLocation());
        if (this.cutsceneController.getEnvironment() == Environment.DEVELOPMENT) {
            CutsceneKeyframeOptionScreen screen = new CutsceneKeyframeOptionScreen(this.keyframeB, this.playerSession, false);
            Minecraft.getInstance().setScreen((Screen)screen);
            this.cutsceneController.pause();
        }
    }

    private void pickNextKeyframes() {
        CutsceneKeyframeGroup cutsceneKeyframeGroupB;
        if (this.currentKeyframeGroup.getKeyframes().size() == 1) {
            this.keyframeB = this.cutsceneController.getNextKeyframe(this.keyframeB);
        }
        if ((cutsceneKeyframeGroupB = (CutsceneKeyframeGroup)this.cutsceneController.getKeyframeGroupOfKeyframe(this.keyframeB)).getKeyframes().size() == 1) {
            this.keyframeA = (CutsceneKeyframe)cutsceneKeyframeGroupB.getKeyframes().getFirst();
        } else if (this.currentKeyframeGroup.getId() != cutsceneKeyframeGroupB.getId()) {
            this.keyframeA = (CutsceneKeyframe)cutsceneKeyframeGroupB.getKeyframes().getFirst();
            this.keyframeB = this.cutsceneController.getNextKeyframe(this.keyframeA);
        } else {
            this.keyframeA = this.keyframeB;
            this.keyframeB = this.cutsceneController.getNextKeyframe(this.keyframeB);
        }
        this.segmentTick = 0;
        this.currentKeyframeGroup = (CutsceneKeyframeGroup)this.cutsceneController.getKeyframeGroupOfKeyframe(this.keyframeB);
    }

    public KeyframeLocation interpolate(double delta, KeyframeLocation a, KeyframeLocation b) {
        if (!this.isPlaying) {
            return null;
        }
        Vec3 position = Mth.lerp((double)delta, (Vec3)a.getPosition(), (Vec3)b.getPosition());
        float pitch = (float)Mth.lerp((double)delta, (double)a.getPitch(), (double)b.getPitch());
        float yaw = (float)Mth.lerp((double)delta, (double)Mth.wrapDegrees((float)a.getYaw()), (double)Mth.wrapDegrees((float)b.getYaw()));
        float roll = (float)Mth.lerp((double)delta, (double)Mth.wrapDegrees((float)a.getRoll()), (double)Mth.wrapDegrees((float)b.getRoll()));
        float fov = (float)Mth.lerp((double)delta, (double)a.getFov(), (double)b.getFov());
        return new KeyframeLocation(position, pitch, yaw, roll, fov);
    }

    public CutsceneKeyframe getKeyframeA() {
        return this.keyframeA;
    }

    public void setKeyframeA(CutsceneKeyframe keyframeA) {
        this.keyframeA = keyframeA;
    }

    public CutsceneKeyframe getKeyframeB() {
        return this.keyframeB;
    }

    public void setKeyframeB(CutsceneKeyframe keyframeB) {
        this.keyframeB = keyframeB;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public int getSegmentTick() {
        return this.segmentTick;
    }

    public void setSegmentTick(int segmentTick) {
        this.segmentTick = segmentTick;
    }

    public int getTotalTick() {
        return this.totalTick;
    }

    public void setTotalTick(int totalTick) {
        this.totalTick = totalTick;
    }
}

